/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x.extension;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.internal.tools.wizards.classes.NewHandlerClassWizard;
import org.eclipse.e4.tools.emf.editor3x.extension.Util;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class HandlerContributionEditor
implements IContributionClassCreator {
    public void createOpen(MContribution contribution, EditingDomain domain, IProject project, Shell shell) {
        this.createOpen(contribution, domain, project, shell, false);
    }

    private void createOpen(MContribution contribution, EditingDomain domain, IProject project, Shell shell, boolean forceNew) {
        if (contribution.getContributionURI() == null || contribution.getContributionURI().trim().length() == 0 || !contribution.getContributionURI().startsWith("bundleclass:")) {
            NewHandlerClassWizard wizard = new NewHandlerClassWizard();
            wizard.init(null, (IStructuredSelection)new StructuredSelection((Object)project));
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (dialog.open() == 0) {
                IFile f = wizard.getFile();
                ICompilationUnit el = JavaCore.createCompilationUnitFrom((IFile)f);
                try {
                    String fullyQualified;
                    if (el.getPackageDeclarations() != null && el.getPackageDeclarations().length > 0) {
                        String packageName = el.getPackageDeclarations()[0].getElementName();
                        String className = wizard.getDomainClass().getName();
                        fullyQualified = packageName.trim().length() > 0 ? String.valueOf(packageName) + "." + className : className;
                    } else {
                        fullyQualified = wizard.getDomainClass().getName();
                    }
                    Command cmd = SetCommand.create((EditingDomain)domain, (Object)contribution, (Object)ApplicationPackageImpl.Literals.CONTRIBUTION__CONTRIBUTION_URI, (Object)("bundleclass://" + Util.getBundleSymbolicName(f.getProject()) + "/" + fullyQualified));
                    if (cmd.canExecute()) {
                        domain.getCommandStack().execute(cmd);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        } else {
            URI uri = URI.createURI((String)contribution.getContributionURI());
            if (uri.hasAuthority() && uri.segmentCount() == 1) {
                String symbolicName = uri.authority();
                String fullyQualified = uri.segment(0);
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(symbolicName);
                if (!p.exists()) {
                    IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = iProjectArray.length;
                    int cmd = 0;
                    while (cmd < n) {
                        IProject check = iProjectArray[cmd];
                        String name = Util.getBundleSymbolicName(check);
                        if (symbolicName.equals(name)) {
                            p = check;
                            break;
                        }
                        ++cmd;
                    }
                }
                if (p != null) {
                    IJavaProject jp = JavaCore.create((IProject)p);
                    try {
                        IType t = jp.findType(fullyQualified);
                        if (t != null) {
                            JavaUI.openInEditor((IJavaElement)t);
                        } else if (MessageDialog.openQuestion((Shell)shell, (String)"Class not found", (String)("The class '" + fullyQualified + "' was not found. Would you like to start the class creation wizard?"))) {
                            this.createOpen(contribution, domain, project, shell, true);
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        if (MessageDialog.openQuestion((Shell)shell, (String)"Class not found", (String)("The class '" + fullyQualified + "' was not found. Would you like to start the class creation wizard?"))) {
                            this.createOpen(contribution, domain, project, shell, true);
                        }
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)shell, (String)"Failed to open editor", (String)e.getMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                MessageDialog.openError((Shell)shell, (String)"Invalid URL", (String)"The current url is invalid");
            }
        }
    }

    public boolean isSupported(EClass element) {
        return Util.isTypeOrSuper(CommandsPackageImpl.Literals.HANDLER, element) || Util.isTypeOrSuper(MenuPackageImpl.Literals.DIRECT_MENU_ITEM, element) || Util.isTypeOrSuper(MenuPackageImpl.Literals.DIRECT_TOOL_ITEM, element);
    }
}

