/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.graphics.util;

import org.eclipse.e4.tm.graphics.util.AbstractCloneable;
import org.eclipse.e4.tm.graphics.util.Util;

public class Dimension
extends AbstractCloneable {
    public double width;
    public double height;
    private static String toStringPrefix = "";
    private static String toStringSuffix = "";

    public Dimension() {
        this(0.0, 0.0);
    }

    public Dimension(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public Dimension(Dimension dim) {
        this(dim.width, dim.height);
    }

    public String toString() {
        return String.valueOf(toStringPrefix) + this.width + "x" + this.height + toStringSuffix;
    }

    public static Dimension valueOf(String s) {
        double[] doubles = Util.valueOf(s, toStringPrefix, "[;,x]", toStringSuffix);
        double width = doubles.length > 1 ? doubles[0] : 0.0;
        double height = doubles.length > 1 ? doubles[1] : 0.0;
        return new Dimension(width, height);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isEmpty() {
        return this.width == 0.0 || this.height == 0.0;
    }

    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void setSize(Dimension dim) {
        this.setSize(dim.width, dim.height);
    }

    public int compareTo(Object o) {
        if (o instanceof Dimension) {
            Dimension rect = (Dimension)o;
            double diff = rect.width - this.width;
            if (diff == 0.0) {
                diff = rect.height - this.height;
            }
            return (int)Math.signum(diff);
        }
        throw new IllegalArgumentException("Cannot compare " + this + " with " + o);
    }
}

