/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.stringconverters;

import java.lang.reflect.Array;
import java.util.StringTokenizer;
import org.eclipse.e4.tm.stringconverter.AbstractStringConverter;
import org.eclipse.e4.tm.stringconverter.StringConverterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayStringConverter
extends AbstractStringConverter {
    private String delimiters = " \t\r\n";
    private String parenthesis = "(,)[ ]{;}<|>";

    public ArrayStringConverter() {
    }

    public ArrayStringConverter(String delimiters) {
        this();
        this.delimiters = delimiters;
    }

    @Override
    public <T> T convert(String source, Class<T> klass, StringConverterContext stringConverter) {
        Class<?> elementClass = klass.getComponentType();
        String delimiters = this.delimiters;
        if (source.length() > 1) {
            char first = source.charAt(0);
            char last = source.charAt(source.length() - 1);
            int i = 0;
            while (i < this.parenthesis.length()) {
                if (first == this.parenthesis.charAt(i) && last == this.parenthesis.charAt(i + 2)) {
                    delimiters = this.parenthesis.substring(i + 1, i + 2);
                    source = source.substring(1, source.length() - 1);
                    break;
                }
                i += 3;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(source, delimiters);
        int tokens = stringTokenizer.countTokens();
        Object array = Array.newInstance(elementClass, tokens);
        int i = 0;
        while (i < tokens) {
            String token = stringTokenizer.nextToken();
            if (delimiters == this.delimiters) {
                token = token.trim();
            }
            try {
                Object o = stringConverter.convert(token, elementClass);
                Array.set(array, i, o);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't create array of " + array.getClass(), e);
            }
            ++i;
        }
        return (T)array;
    }
}

