/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.jdt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedConstructorsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTHelper {
    public static IType createType(IPackageFragment pack, String typeName, Collection<Class<?>> superInterfaces, Class<?> superClass) {
        try {
            String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)pack.getJavaProject());
            String cuName = String.valueOf(typeName) + ".java";
            ICompilationUnit parentCU = pack.createCompilationUnit(cuName, "", false, null);
            parentCU.becomeWorkingCopy(null);
            IBuffer buffer = parentCU.getBuffer();
            String simpleTypeStub = ASTHelper.constructSimpleTypeStub(typeName);
            String cuContent = ASTHelper.constructCUContent(parentCU, simpleTypeStub, lineDelimiter);
            buffer.setContents(cuContent);
            CompilationUnit astRoot = ASTHelper.createASTForImports(parentCU);
            Set existingImports = ASTHelper.getExistingImports(astRoot);
            ImportsManager imports = new ImportsManager(astRoot);
            imports.addImport(JavaModelUtil.concatenateName((String)pack.getElementName(), (String)typeName));
            String typeContent = ASTHelper.constructTypeStub(typeName, superInterfaces, superClass, parentCU, imports, lineDelimiter);
            int index = cuContent.lastIndexOf(simpleTypeStub);
            if (index == -1) {
                AbstractTypeDeclaration typeNode = (AbstractTypeDeclaration)astRoot.types().get(0);
                int start = ((ASTNode)typeNode.modifiers().get(0)).getStartPosition();
                int end = typeNode.getStartPosition() + typeNode.getLength();
                buffer.replace(start, end - start, typeContent);
            } else {
                buffer.replace(index, simpleTypeStub.length(), typeContent);
            }
            IType createdType = parentCU.getType(typeName);
            ICompilationUnit cu = createdType.getCompilationUnit();
            imports.create(false, null);
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            astRoot = ASTHelper.createASTForImports(imports.getCompilationUnit());
            imports = new ImportsManager(astRoot);
            ASTHelper.createTypeMembers(createdType, imports);
            imports.create(false, null);
            ASTHelper.removeUnusedImports(cu, existingImports, false);
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            ASTHelper.format(createdType, lineDelimiter);
            return createdType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void format(IType type, String lineDelimiter) throws JavaModelException {
        ISourceRange range = type.getSourceRange();
        ICompilationUnit cu = type.getCompilationUnit();
        IBuffer buf = cu.getBuffer();
        String originalContent = buf.getText(range.getOffset(), range.getLength());
        String formattedContent = CodeFormatterUtil.format((int)4, (String)originalContent, (int)0, (String)lineDelimiter, (IJavaProject)type.getJavaProject());
        formattedContent = Strings.trimLeadingTabsAndSpaces((String)formattedContent);
        buf.replace(range.getOffset(), range.getLength(), formattedContent);
        cu.commitWorkingCopy(true, null);
    }

    public static IMethod createMethod(IType type, String methodName, Class<?> returnType, String contentReturnValue, List<Class<?>> arguments) {
        try {
            ICompilationUnit cu = type.getCompilationUnit();
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            CompilationUnit astUnit = ASTHelper.createASTForImports(cu);
            ImportsManager imports = new ImportsManager(astUnit);
            Set existingImports = ASTHelper.getExistingImports(astUnit);
            ArrayList<String> paraNames = new ArrayList<String>();
            if (arguments != null) {
                for (Class<?> arg : arguments) {
                    paraNames.add(arg.getSimpleName());
                    imports.addImport(arg.getName());
                }
            }
            String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)type.getJavaProject());
            StringBuilder contents = new StringBuilder();
            String comment = CodeGeneration.getMethodComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)methodName, (String[])paraNames.toArray(new String[paraNames.size()]), (String[])new String[]{}, (String)Signature.createTypeSignature((String)(returnType == null ? "void" : returnType.getSimpleName()), (boolean)true), null, (String)lineDelimiter);
            if (comment != null) {
                contents.append(comment);
                contents.append(lineDelimiter);
            }
            if (returnType != null) {
                imports.addImport(returnType.getName());
            }
            contents.append("public " + (returnType == null ? "void " : String.valueOf(returnType.getSimpleName()) + " ") + methodName + "(");
            int i = 0;
            while (i < paraNames.size()) {
                String arg = (String)paraNames.get(i);
                contents.append(String.valueOf(arg) + " " + Character.toLowerCase(arg.charAt(0)) + arg.substring(1));
                if (i < paraNames.size()) {
                    contents.append(" ");
                }
                ++i;
            }
            contents.append(") {");
            contents.append(lineDelimiter);
            String content = CodeGeneration.getMethodBodyContent((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)methodName, (boolean)false, (String)"", (String)lineDelimiter);
            if (content != null && content.length() != 0) {
                contents.append("\t" + content);
            }
            if (returnType != null) {
                contents.append("\treturn " + contentReturnValue + ";");
                contents.append(lineDelimiter);
            }
            contents.append("}");
            ASTHelper.removeUnusedImports(cu, existingImports, true);
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            ASTHelper.format(type, lineDelimiter);
            return type.createMethod(contents.toString(), null, true, null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected static void createTypeMembers(IType type, ImportsManager imports) throws CoreException {
        ASTHelper.createInheritedMethods(type, true, true, imports);
    }

    protected static IMethod[] createInheritedMethods(IType type, boolean doConstructors, boolean doUnimplementedMethods, ImportsManager imports) throws CoreException {
        ICompilationUnit cu = type.getCompilationUnit();
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        IMethod[] typeMethods = type.getMethods();
        HashSet<String> handleIds = new HashSet<String>(typeMethods.length);
        int index = 0;
        while (index < typeMethods.length) {
            handleIds.add(typeMethods[index].getHandleIdentifier());
            ++index;
        }
        ArrayList<IMethod> newMethods = new ArrayList<IMethod>();
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
        settings.createComments = false;
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(cu);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        ITypeBinding binding = ASTNodes.getTypeBinding((CompilationUnit)unit, (IType)type);
        if (binding != null) {
            AddUnimplementedMethodsOperation operation;
            if (doUnimplementedMethods) {
                operation = new AddUnimplementedMethodsOperation(unit, binding, null, -1, false, true, false);
                operation.setCreateComments(false);
                operation.run(null);
                ASTHelper.createImports(imports, operation.getCreatedImports());
            }
            if (doConstructors) {
                operation = new AddUnimplementedConstructorsOperation(unit, binding, null, -1, false, true, false);
                operation.setOmitSuper(true);
                operation.setCreateComments(false);
                operation.run(null);
                ASTHelper.createImports(imports, operation.getCreatedImports());
            }
        }
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        typeMethods = type.getMethods();
        int index2 = 0;
        while (index2 < typeMethods.length) {
            if (!handleIds.contains(typeMethods[index2].getHandleIdentifier())) {
                newMethods.add(typeMethods[index2]);
            }
            ++index2;
        }
        IMethod[] methods = new IMethod[newMethods.size()];
        newMethods.toArray(methods);
        return methods;
    }

    private static void createImports(ImportsManager imports, String[] createdImports) {
        int index = 0;
        while (index < createdImports.length) {
            imports.addImport(createdImports[index]);
            ++index;
        }
    }

    private static void removeUnusedImports(ICompilationUnit cu, Set existingImports, boolean needsSave) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        if (root.getProblems().length == 0) {
            return;
        }
        List importsDecls = root.imports();
        if (importsDecls.isEmpty()) {
            return;
        }
        ImportsManager imports = new ImportsManager(root);
        int importsEnd = ASTNodes.getExclusiveEnd((ASTNode)((ASTNode)importsDecls.get(importsDecls.size() - 1)));
        IProblem[] problems = root.getProblems();
        int i = 0;
        while (i < problems.length) {
            int id;
            IProblem curr = problems[i];
            if (curr.getSourceEnd() < importsEnd && ((id = curr.getID()) == 268435844 || id == 0x1000003)) {
                int pos = curr.getSourceStart();
                int k = 0;
                while (k < importsDecls.size()) {
                    ImportDeclaration decl = (ImportDeclaration)importsDecls.get(k);
                    if (decl.getStartPosition() <= pos && pos < decl.getStartPosition() + decl.getLength()) {
                        if (!existingImports.isEmpty() && existingImports.contains(ASTNodes.asString((ASTNode)decl))) break;
                        String name = decl.getName().getFullyQualifiedName();
                        if (decl.isOnDemand()) {
                            name = String.valueOf(name) + ".*";
                        }
                        if (decl.isStatic()) {
                            imports.removeStaticImport(name);
                            break;
                        }
                        imports.removeImport(name);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        imports.create(needsSave, null);
    }

    private static Set getExistingImports(CompilationUnit root) {
        List imports = root.imports();
        HashSet<String> res = new HashSet<String>(imports.size());
        int i = 0;
        while (i < imports.size()) {
            res.add(ASTNodes.asString((ASTNode)((ImportDeclaration)imports.get(i))));
            ++i;
        }
        return res;
    }

    private static CompilationUnit createASTForImports(ICompilationUnit cu) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(false);
        parser.setFocalPosition(0);
        return (CompilationUnit)parser.createAST(null);
    }

    protected static String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        String fileComment = "";
        String typeComment = "";
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)cu, (String)fileComment, (String)typeComment, (String)typeContent, (String)lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setProject(cu.getJavaProject());
            parser.setSource(content.toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            if ((pack.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                return content;
            }
        }
        StringBuffer buf = new StringBuffer();
        if (!pack.isDefaultPackage()) {
            buf.append("package ").append(pack.getElementName()).append(';');
        }
        buf.append(lineDelimiter).append(lineDelimiter);
        if (typeComment != null) {
            buf.append(typeComment).append(lineDelimiter);
        }
        buf.append(typeContent);
        return buf.toString();
    }

    private static String constructTypeStub(String typeName, Collection<Class<?>> superInterfaces, Class<?> superClass, ICompilationUnit parentCU, ImportsManager imports, String lineDelimiter) throws CoreException {
        StringBuffer buf = new StringBuffer();
        int modifiers = 1;
        buf.append(Flags.toString((int)modifiers));
        if (modifiers != 0) {
            buf.append(' ');
        }
        String type = "class ";
        String templateID = "org.eclipse.jdt.ui.text.codetemplates.classbody";
        buf.append(type);
        buf.append(typeName);
        ASTHelper.writeSuperClass(buf, imports, superClass);
        ASTHelper.writeSuperInterfaces(buf, imports, superInterfaces);
        buf.append(" {").append(lineDelimiter);
        String typeBody = CodeGeneration.getTypeBody((String)templateID, (ICompilationUnit)parentCU, (String)typeName, (String)lineDelimiter);
        if (typeBody != null) {
            buf.append(typeBody);
        } else {
            buf.append(lineDelimiter);
        }
        buf.append('}').append(lineDelimiter);
        return buf.toString();
    }

    private static void writeSuperClass(StringBuffer buf, ImportsManager imports, Class<?> superType) {
        if (superType == null) {
            return;
        }
        String superclass = superType.getName();
        buf.append(" extends ");
        buf.append(imports.addImport(superclass));
    }

    private static void writeSuperInterfaces(StringBuffer buf, ImportsManager imports, Collection<Class<?>> superInterfaces) {
        if (superInterfaces == null || superInterfaces.isEmpty()) {
            return;
        }
        ArrayList<String> interfaces = new ArrayList<String>();
        for (Class<?> t : superInterfaces) {
            String name = t.getName();
            interfaces.add(name);
            imports.addImport(name);
        }
        int last = interfaces.size() - 1;
        if (last >= 0) {
            buf.append(" implements ");
            String[] intfs = interfaces.toArray(new String[interfaces.size()]);
            ITypeBinding[] bindings = new ITypeBinding[intfs.length];
            int i = 0;
            while (i <= last) {
                ITypeBinding binding = bindings[i];
                if (binding != null) {
                    buf.append(imports.addImport(binding));
                } else {
                    buf.append(imports.addImport(intfs[i]));
                }
                if (i < last) {
                    buf.append(',');
                }
                ++i;
            }
        }
    }

    private static String constructSimpleTypeStub(String typeName) {
        StringBuffer buf = new StringBuffer("public class ");
        buf.append(typeName);
        buf.append("{ }");
        return buf.toString();
    }

    public static class ImportsManager {
        private ImportRewrite fImportsRewrite;

        public ImportsManager(CompilationUnit astRoot) {
            this.fImportsRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fImportsRewrite.getCompilationUnit();
        }

        public String addImport(String qualifiedTypeName) {
            return this.fImportsRewrite.addImport(qualifiedTypeName);
        }

        public String addImport(ITypeBinding typeBinding) {
            return this.fImportsRewrite.addImport(typeBinding);
        }

        public String addStaticImport(String declaringTypeName, String simpleName, boolean isField) {
            return this.fImportsRewrite.addStaticImport(declaringTypeName, simpleName, isField);
        }

        public void create(boolean needsSave, IProgressMonitor monitor) throws CoreException {
            TextEdit edit = this.fImportsRewrite.rewriteImports(monitor);
            JavaModelUtil.applyEdit((ICompilationUnit)this.fImportsRewrite.getCompilationUnit(), (TextEdit)edit, (boolean)needsSave, null);
        }

        public void removeImport(String qualifiedName) {
            this.fImportsRewrite.removeImport(qualifiedName);
        }

        public void removeStaticImport(String qualifiedName) {
            this.fImportsRewrite.removeStaticImport(qualifiedName);
        }
    }
}

