/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.Timer;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PStack;
import org.eclipse.e4.tm.graphics.util.Rectangle;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PCanvas
implements PComponent {
    public static final String INTERATING_CHANGED_NOTIFICATION = "INTERATING_CHANGED_NOTIFICATION";
    public static PCanvas CURRENT_ZCANVAS = null;
    private PCamera camera;
    private PStack cursorStack;
    private int interacting;
    private int defaultRenderQuality;
    private int animatingRenderQuality;
    private int interactingRenderQuality;
    private PPanEventHandler panEventHandler;
    private PZoomEventHandler zoomEventHandler;
    private boolean paintingImmediately;
    private boolean animatingOnLastPaint;
    private Listener genericListener;
    private PaintListener paintListener;
    private ControlListener controlListener;
    private Composite control;
    public static final String PCANVAS_CONTROL_DATA_KEY = "edu.umd.cs.piccolo.PCanvas";
    private boolean isButton1Pressed;
    private boolean isButton2Pressed;
    private boolean isButton3Pressed;
    private int[] swtEventTypes = new int[]{1, 2, 3, 4, 5, 6, 7, 37, 15, 16};

    public PCanvas(Composite parent) {
        this.control = parent;
        this.control.setData(PCANVAS_CONTROL_DATA_KEY, (Object)this);
        CURRENT_ZCANVAS = this;
        this.cursorStack = new PStack();
        this.setCamera(this.createDefaultCamera());
        this.installInputSources();
        this.setDefaultRenderQuality(1);
        this.setAnimatingRenderQuality(0);
        this.setInteractingRenderQuality(0);
        this.setPanEventHandler(new PPanEventHandler());
        this.setZoomEventHandler(new PZoomEventHandler());
    }

    public void addLayer(PLayer layer) {
        this.getRoot().addChild(layer);
        this.getCamera().addLayer(layer);
    }

    protected PCamera createDefaultCamera() {
        PRoot r = new PRoot(this.control.getDisplay());
        PCamera c = new PCamera();
        r.addChild(c);
        return c;
    }

    public PPanEventHandler getPanEventHandler() {
        return this.panEventHandler;
    }

    public void setPanEventHandler(PPanEventHandler handler) {
        if (this.panEventHandler != null) {
            this.removeInputEventListener(this.panEventHandler);
        }
        this.panEventHandler = handler;
        if (this.panEventHandler != null) {
            this.addInputEventListener(this.panEventHandler);
        }
    }

    public PZoomEventHandler getZoomEventHandler() {
        return this.zoomEventHandler;
    }

    public void setZoomEventHandler(PZoomEventHandler handler) {
        if (this.zoomEventHandler != null) {
            this.removeInputEventListener(this.zoomEventHandler);
        }
        this.zoomEventHandler = handler;
        if (this.zoomEventHandler != null) {
            this.addInputEventListener(this.zoomEventHandler);
        }
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setCamera(PCamera newCamera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = newCamera;
        if (this.camera != null) {
            this.camera.setComponent(this);
            org.eclipse.swt.graphics.Rectangle swtRectangle = this.control.getBounds();
            this.camera.setBounds(new Rectangle(swtRectangle.x, swtRectangle.y, swtRectangle.width, swtRectangle.height));
        }
    }

    public void setBounds(org.eclipse.swt.graphics.Rectangle swtRectangle) {
        this.control.setBounds(swtRectangle);
        this.camera.setBounds(new Rectangle(swtRectangle.x, swtRectangle.y, swtRectangle.width, swtRectangle.height));
    }

    public PRoot getRoot() {
        return this.camera.getRoot();
    }

    public PLayer getLayer() {
        return this.camera.getLayer(0);
    }

    public void addInputEventListener(PInputEventListener listener) {
        this.getCamera().addInputEventListener(listener);
    }

    public void removeInputEventListener(PInputEventListener listener) {
        this.getCamera().removeInputEventListener(listener);
    }

    public boolean getInteracting() {
        return this.interacting > 0;
    }

    public boolean getAnimating() {
        return this.getRoot().getActivityScheduler().getAnimating();
    }

    public void setInteracting(boolean isInteracting) {
        boolean wasInteracting = this.getInteracting();
        this.interacting = isInteracting ? ++this.interacting : --this.interacting;
        if (!this.getInteracting()) {
            int nextRenderQuality = this.defaultRenderQuality;
            if (this.getAnimating()) {
                nextRenderQuality = this.animatingRenderQuality;
            }
            if (nextRenderQuality > this.interactingRenderQuality) {
                this.control.redraw();
            }
        }
        isInteracting = this.getInteracting();
    }

    public void setDefaultRenderQuality(int requestedQuality) {
        this.defaultRenderQuality = requestedQuality;
        this.control.redraw();
    }

    public void setAnimatingRenderQuality(int requestedQuality) {
        this.animatingRenderQuality = requestedQuality;
        if (this.getAnimating()) {
            this.control.redraw();
        }
    }

    public void setInteractingRenderQuality(int requestedQuality) {
        this.interactingRenderQuality = requestedQuality;
        if (this.getInteracting()) {
            this.control.redraw();
        }
    }

    public void pushCursor(Cursor cursor) {
        this.cursorStack.push(this.control.getCursor());
        this.control.setCursor(cursor);
    }

    public void popCursor() {
        this.control.setCursor((Cursor)this.cursorStack.pop());
    }

    protected void installInputSources() {
        if (this.genericListener == null) {
            this.genericListener = new Listener(){

                public void handleEvent(Event event) {
                    if (!PCanvas.this.control.isEnabled()) {
                        return;
                    }
                    if (event.type == 3) {
                        if (event.button == 1) {
                            event.stateMask |= 0x80000;
                        } else if (event.button == 2) {
                            event.stateMask |= 0x100000;
                        } else if (event.button == 3) {
                            event.stateMask |= 0x200000;
                        }
                    }
                    if (event.type == 6) {
                        Event simulated = PCanvas.this.createUntypedEvent(event);
                        simulated.type = 5;
                        PCanvas.this.sendInputEventToInputManager(event, 6);
                        PCanvas.this.sendInputEventToInputManager(simulated, simulated.type);
                    } else if (event.type == 7) {
                        Event simulated = PCanvas.this.createUntypedEvent(event);
                        simulated.type = 5;
                        PCanvas.this.sendInputEventToInputManager(simulated, simulated.type);
                        PCanvas.this.sendInputEventToInputManager(event, 7);
                    } else if (event.type == 3) {
                        PCanvas.this.control.setFocus();
                        boolean shouldBalanceEvent = false;
                        if ((event.stateMask & 0x80000) != 0) {
                            if (PCanvas.this.isButton1Pressed) {
                                shouldBalanceEvent = true;
                            }
                            PCanvas.this.isButton1Pressed = true;
                        } else if ((event.stateMask & 0x100000) != 0) {
                            if (PCanvas.this.isButton2Pressed) {
                                shouldBalanceEvent = true;
                            }
                            PCanvas.this.isButton2Pressed = true;
                        } else if ((event.stateMask & 0x200000) != 0) {
                            if (PCanvas.this.isButton3Pressed) {
                                shouldBalanceEvent = true;
                            }
                            PCanvas.this.isButton3Pressed = true;
                        }
                        if (shouldBalanceEvent) {
                            Event balanceEvent = PCanvas.this.createUntypedEvent(event);
                            balanceEvent.type = 4;
                            PCanvas.this.sendInputEventToInputManager(balanceEvent, 4);
                        }
                        PCanvas.this.sendInputEventToInputManager(event, 3);
                    } else if (event.type == 4) {
                        boolean shouldBalanceEvent = false;
                        if ((event.stateMask & 0x80000) != 0) {
                            if (PCanvas.this.isButton1Pressed) {
                                shouldBalanceEvent = true;
                            }
                            PCanvas.this.isButton1Pressed = false;
                        } else if ((event.stateMask & 0x100000) != 0) {
                            if (PCanvas.this.isButton2Pressed) {
                                shouldBalanceEvent = true;
                            }
                            PCanvas.this.isButton2Pressed = false;
                        } else if ((event.stateMask & 0x200000) != 0) {
                            if (PCanvas.this.isButton3Pressed) {
                                shouldBalanceEvent = true;
                            }
                            PCanvas.this.isButton3Pressed = false;
                        }
                        if (shouldBalanceEvent) {
                            Event balanceEvent = PCanvas.this.createUntypedEvent(event);
                            balanceEvent.type = 3;
                            PCanvas.this.sendInputEventToInputManager(balanceEvent, 3);
                        }
                        PCanvas.this.sendInputEventToInputManager(event, 4);
                    } else if (event.type == 5) {
                        if (PCanvas.this.isButton1Pressed | PCanvas.this.isButton2Pressed | PCanvas.this.isButton3Pressed) {
                            event.type = 44;
                        }
                        PCanvas.this.sendInputEventToInputManager(event, event.type);
                    } else {
                        PCanvas.this.sendInputEventToInputManager(event, event.type);
                    }
                }
            };
            int i = 0;
            while (i < this.swtEventTypes.length) {
                this.control.addListener(this.swtEventTypes[i], this.genericListener);
                ++i;
            }
        }
        if (this.paintListener == null) {
            this.paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    PCanvas.this.paintComponent(e.gc);
                }
            };
            this.control.addPaintListener(this.paintListener);
        }
        if (this.controlListener == null) {
            this.controlListener = new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    Point size = PCanvas.this.control.getSize();
                    PCanvas.this.camera.setBounds(PCanvas.this.camera.getX(), PCanvas.this.camera.getY(), size.x, size.y);
                }
            };
            this.control.addControlListener(this.controlListener);
        }
    }

    protected void removeInputSources() {
        if (this.controlListener != null) {
            this.control.removeControlListener(this.controlListener);
            this.controlListener = null;
        }
        if (this.paintListener != null) {
            this.control.removePaintListener(this.paintListener);
            this.paintListener = null;
        }
        if (this.genericListener != null) {
            int i = 0;
            while (i < this.swtEventTypes.length) {
                this.control.removeListener(this.swtEventTypes[i], this.genericListener);
                ++i;
            }
            this.genericListener = null;
        }
    }

    private Event createUntypedEvent(Event e) {
        Event untypedEvent = new Event();
        untypedEvent.display = e.display;
        untypedEvent.widget = e.widget;
        untypedEvent.time = e.time;
        untypedEvent.type = e.type;
        untypedEvent.data = e.data;
        untypedEvent.button = e.button;
        untypedEvent.keyCode = e.keyCode;
        untypedEvent.character = e.character;
        untypedEvent.count = e.count;
        untypedEvent.x = e.x;
        untypedEvent.y = e.x;
        untypedEvent.stateMask = e.stateMask;
        return untypedEvent;
    }

    protected void sendInputEventToInputManager(Event e, int type) {
        this.getRoot().getDefaultInputManager().processEventFromCamera(e, type, this.getCamera());
    }

    public void repaint(PBounds bounds) {
        PDebug.processRepaint(this.control.getDisplay());
        bounds.expandNearestIntegerDimensions();
        bounds.inset(-1.0, -1.0);
        this.control.redraw((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, true);
    }

    private void paintComponent(GC g) {
        PDebug.startProcessingOutput();
        GC g2 = g;
        g2.setBackground(this.control.getBackground());
        g2.fillRectangle(this.control.getBounds());
        PPaintContext paintContext = new PPaintContext(g2);
        if (this.getInteracting() || this.getAnimating()) {
            if (this.interactingRenderQuality < this.animatingRenderQuality) {
                paintContext.setRenderQuality(this.interactingRenderQuality);
            } else {
                paintContext.setRenderQuality(this.animatingRenderQuality);
            }
        } else {
            paintContext.setRenderQuality(this.defaultRenderQuality);
        }
        this.camera.fullPaint(paintContext);
        if (!this.getAnimating() && this.animatingOnLastPaint) {
            this.control.redraw();
        }
        this.animatingOnLastPaint = this.getAnimating();
        PDebug.endProcessingOutput(g2);
    }

    public void paintImmediately() {
        if (this.paintingImmediately) {
            return;
        }
        this.paintingImmediately = true;
        this.paintingImmediately = false;
    }

    public Timer createTimer(int delay, Runnable runnable) {
        return new Timer(this.control.getDisplay(), delay, runnable);
    }
}

