/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.xp.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.internal.xp.IContributionsReader;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;

public abstract class AbstractExtensionPointParser<T>
implements IContributionsReader<T> {
    private final IExtensionRegistry extRegistry;
    private final String xpId;
    private final String elementName;

    protected AbstractExtensionPointParser(IExtensionRegistry extRegistry, String xpId, String elementName) {
        this.extRegistry = extRegistry;
        this.xpId = xpId;
        this.elementName = elementName;
    }

    @Override
    public final List<T> readContributions() {
        ArrayList<T> result = new ArrayList<T>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            try {
                result.add(this.createObject(element));
            }
            catch (CoreException e) {
                this.logger().logError("Problem creating contributor from configuration element", (Throwable)e);
            }
        }
        return result;
    }

    protected ILogger logger() {
        return Logger.instance();
    }

    protected abstract T createObject(IConfigurationElement var1) throws CoreException;

    private List<IConfigurationElement> getConfigurationElements() {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtensionPoint extPoint = this.extRegistry.getExtensionPoint(this.xpId);
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getName().equals(this.elementName)) {
                result.add(elem);
            }
            ++n2;
        }
        return result;
    }
}

