/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Assert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.provider.DefaultContentProvider;
import org.eclipse.core.internal.resources.semantic.provider.InvalidContentProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.test.TestsContentProviderUtil;
import org.eclipse.core.resources.semantic.test.provider.FederatedContentProvider;
import org.eclipse.core.resources.semantic.test.provider.FederatingContentProvider2;
import org.eclipse.core.resources.semantic.test.provider.FederatingContentProvider3;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestsFederatingProvider2
extends TestsContentProviderUtil {
    public TestsFederatingProvider2() {
        super(false, "TestSFSFederationProject2", FederatingContentProvider2.class.getName());
    }

    @Before
    public void beforeMethod() throws Exception {
        TestsContentProviderUtil.initTrace();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProjectDescription description = workspace.newProjectDescription(TestsFederatingProvider2.this.projectName);
                try {
                    description.setLocationURI(new URI("semanticfs:/" + TestsFederatingProvider2.this.projectName));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                project.create(description, monitor);
                project.open(monitor);
                RepositoryProvider.map((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                ISemanticProject spr = (ISemanticProject)project.getAdapter(ISemanticProject.class);
                spr.addFolder("root", FederatingContentProvider2.class.getName(), null, 0, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        workspace.run(myRunnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        this.testProject = project;
    }

    @After
    public void afterMethod() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.projectName);
        project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        TestsContentProviderUtil.resetTrace();
        this.testProject = null;
    }

    @Test
    public void testFederationAndImplicitLocalFlag() throws Exception {
        final IFolder federatingFolder = this.testProject.getFolder((IPath)new Path("root/A/B/C"));
        final IFolder restFolder = this.testProject.getFolder((IPath)new Path("root/A/C"));
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile restSFile;
                ISemanticFolder federatingSFolder = (ISemanticFolder)federatingFolder.getAdapter(ISemanticFolder.class);
                ISemanticFile sfile = federatingSFolder.addFile("test", TestsFederatingProvider2.this.options, null);
                ISemanticFileStore sstore = (ISemanticFileStore)EFS.getStore((URI)sfile.getAdaptedResource().getLocationURI());
                ISemanticContentProvider cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatedContentProvider.class.getName(), (String)cp.getClass().getName());
                sstore = (ISemanticFileStore)EFS.getStore((URI)federatingSFolder.getAdaptedResource().getLocationURI());
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatedContentProvider.class.getName(), (String)cp.getClass().getName());
                sstore = (ISemanticFileStore)sstore.getParent().getParent();
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider2.class.getName(), (String)cp.getClass().getName());
                ISemanticFolder restSFolder = (ISemanticFolder)restFolder.getAdapter(ISemanticFolder.class);
                try {
                    File testfile = TestsFederatingProvider2.this.createTestFile("test.txt");
                    boolean created = testfile.createNewFile();
                    if (!created) {
                        new FileOutputStream(testfile).close();
                    }
                    restSFile = restSFolder.addFile("Hi.all", TestsFederatingProvider2.this.createURI4File(testfile), TestsFederatingProvider2.this.options, monitor);
                    sstore = (ISemanticFileStore)EFS.getStore((URI)restSFile.getAdaptedResource().getLocationURI());
                    cp = sstore.getEffectiveContentProvider();
                    Assert.assertEquals((String)"Wrong content provider", (String)DefaultContentProvider.class.getName(), (String)cp.getClass().getName());
                    Assert.assertFalse((String)("Resource should not exist " + sfile.getAdaptedResource().getLocationURI()), (boolean)sfile.getAdaptedResource().exists());
                    Assert.assertFalse((String)("Resource should not exist " + restSFile.getAdaptedResource().getLocationURI()), (boolean)restSFile.getAdaptedResource().exists());
                }
                catch (URISyntaxException e) {
                    Assert.fail((String)e.getMessage());
                    restSFile = null;
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                    restSFile = null;
                }
                TestsFederatingProvider2.this.testProject.refreshLocal(2, monitor);
                IContainer parentFolder = restFolder.getParent();
                ISemanticFolder parent = (ISemanticFolder)parentFolder.getAdapter(ISemanticFolder.class);
                ISemanticResourceInfo info = parent.fetchResourceInfo(8, monitor);
                Assert.assertTrue((String)"Should be local-only", (boolean)info.isLocalOnly());
                Assert.assertTrue((String)("Resource should exist " + sfile.getAdaptedResource().getLocationURI()), (boolean)sfile.getAdaptedResource().exists());
                sfile.getAdaptedFile().getContents();
                Assert.assertTrue((String)("Resource should exist " + sfile.getAdaptedResource().getLocationURI()), (boolean)sfile.getAdaptedResource().exists());
                IFile file = (IFile)sfile.getAdaptedResource();
                IStatus result = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)Display.getCurrent());
                Assert.assertTrue((String)"Validate Edit should return ok", (boolean)result.isOK());
                file.setContents((InputStream)new ByteArrayInputStream(new byte[0]), true, true, monitor);
                Assert.assertTrue((String)("Resource should exist " + sfile.getAdaptedResource().getLocationURI()), (boolean)sfile.getAdaptedResource().exists());
                Assert.assertTrue((String)("Resource should exist " + restSFile.getAdaptedResource().getLocationURI()), (boolean)restSFile.getAdaptedResource().exists());
                restSFolder.remove(4, monitor);
                Assert.assertFalse((String)("Resource should not exist " + restSFile.getAdaptedResource().getLocationURI()), (boolean)restSFile.getAdaptedResource().exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testFederationAndInvalidContentProviderID() throws Exception {
        final IFolder federatingFolder = this.testProject.getFolder((IPath)new Path("root/A/D"));
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder federatingSFolder = (ISemanticFolder)federatingFolder.getAdapter(ISemanticFolder.class);
                try {
                    federatingSFolder.addFile("test", TestsFederatingProvider2.this.options, null);
                    Assert.assertTrue((String)"should have failed", (boolean)false);
                }
                catch (CoreException coreException) {}
                ISemanticFileStore sstore = (ISemanticFileStore)EFS.getStore((URI)federatingSFolder.getAdaptedResource().getLocationURI());
                ISemanticContentProvider cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)InvalidContentProvider.class.getName(), (String)cp.getClass().getName());
                sstore = (ISemanticFileStore)sstore.getParent().getParent();
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider2.class.getName(), (String)cp.getClass().getName());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testFederationAndInvalidContentProviderID2() throws Exception {
        final IFolder federatingFolder = this.testProject.getFolder((IPath)new Path("root/A/D/C"));
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder federatingSFolder = (ISemanticFolder)federatingFolder.getAdapter(ISemanticFolder.class);
                try {
                    federatingSFolder.addFile("test", TestsFederatingProvider2.this.options, null);
                    Assert.assertTrue((String)"should have failed", (boolean)false);
                }
                catch (CoreException coreException) {}
                ISemanticFileStore sstore = (ISemanticFileStore)EFS.getStore((URI)federatingSFolder.getAdaptedResource().getLocationURI());
                ISemanticContentProvider cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)InvalidContentProvider.class.getName(), (String)cp.getClass().getName());
                sstore = (ISemanticFileStore)sstore.getParent().getParent();
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider2.class.getName(), (String)cp.getClass().getName());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testRecursiveFederation() throws Exception {
        final IFolder federatingFolder = this.testProject.getFolder((IPath)new Path("root/A/E/X/B"));
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder federatingSFolder = (ISemanticFolder)federatingFolder.getAdapter(ISemanticFolder.class);
                ISemanticFile sFile = federatingSFolder.addFile("test", TestsFederatingProvider2.this.options, null);
                ISemanticFileStore sstore = (ISemanticFileStore)EFS.getStore((URI)sFile.getAdaptedResource().getLocationURI());
                ISemanticContentProvider cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatedContentProvider.class.getName(), (String)cp.getClass().getName());
                Assert.assertEquals((String)"Wrong content provider ID", (String)FederatedContentProvider.class.getName(), (String)sstore.getEffectiveContentProviderID());
                sstore = (ISemanticFileStore)EFS.getStore((URI)federatingSFolder.getAdaptedResource().getLocationURI());
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatedContentProvider.class.getName(), (String)cp.getClass().getName());
                Assert.assertEquals((String)"Wrong content provider ID", (String)FederatedContentProvider.class.getName(), (String)sstore.getEffectiveContentProviderID());
                sstore = (ISemanticFileStore)sstore.getParent();
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider3.class.getName(), (String)cp.getClass().getName());
                Assert.assertEquals((String)"Wrong content provider ID", (String)FederatingContentProvider3.class.getName(), (String)sstore.getEffectiveContentProviderID());
                sstore = (ISemanticFileStore)sstore.getParent();
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider3.class.getName(), (String)cp.getClass().getName());
                Assert.assertEquals((String)"Wrong content provider ID", (String)FederatingContentProvider3.class.getName(), (String)sstore.getEffectiveContentProviderID());
                sstore = (ISemanticFileStore)sstore.getParent();
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider2.class.getName(), (String)cp.getClass().getName());
                Assert.assertEquals((String)"Wrong content provider ID", (String)FederatingContentProvider2.class.getName(), (String)sstore.getEffectiveContentProviderID());
                sstore = (ISemanticFileStore)sstore.getParent();
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider2.class.getName(), (String)cp.getClass().getName());
                Assert.assertEquals((String)"Wrong content provider ID", (String)FederatingContentProvider2.class.getName(), (String)sstore.getEffectiveContentProviderID());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testRecursiveFederation2() throws Exception {
        final IFolder federatingFolder = this.testProject.getFolder((IPath)new Path("root"));
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder federatingSFolder = (ISemanticFolder)federatingFolder.getAdapter(ISemanticFolder.class);
                ISemanticFileStore sstore = (ISemanticFileStore)EFS.getStore((URI)federatingSFolder.getAdaptedResource().getLocationURI());
                ISemanticContentProvider cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider2.class.getName(), (String)cp.getClass().getName());
                sstore = (ISemanticFileStore)sstore.getChild("A");
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider2.class.getName(), (String)cp.getClass().getName());
                sstore = (ISemanticFileStore)sstore.getChild("E");
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider3.class.getName(), (String)cp.getClass().getName());
                sstore = (ISemanticFileStore)sstore.getChild("X");
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider3.class.getName(), (String)cp.getClass().getName());
                sstore = (ISemanticFileStore)sstore.getChild("B");
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatedContentProvider.class.getName(), (String)cp.getClass().getName());
                IFolder federatingFolder2 = TestsFederatingProvider2.this.testProject.getFolder((IPath)new Path("root/A/E/X"));
                ISemanticFolder federatingSFolder2 = (ISemanticFolder)federatingFolder2.getAdapter(ISemanticFolder.class);
                ISemanticFile sFile = federatingSFolder2.addFile("test", TestsFederatingProvider2.this.options, null);
                sstore = (ISemanticFileStore)EFS.getStore((URI)sFile.getAdaptedResource().getLocationURI());
                cp = sstore.getEffectiveContentProvider();
                Assert.assertEquals((String)"Wrong content provider", (String)FederatingContentProvider3.class.getName(), (String)cp.getClass().getName());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }
}

