/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.integration.internal.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.core.api.ISearchConsoleSlaveController;
import org.eclipse.platform.discovery.core.api.ISearchFavoritesMasterController;
import org.eclipse.platform.discovery.core.api.ISearchFavoritesSlaveController;
import org.eclipse.platform.discovery.core.internal.IDiscoveryView;
import org.eclipse.platform.discovery.core.internal.ISearchConsoleView;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleController;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleControllerOutputView;
import org.eclipse.platform.discovery.core.internal.favorites.IPersistenceUtil;
import org.eclipse.platform.discovery.core.internal.favorites.ISearchFavoritesControllerOutputView;
import org.eclipse.platform.discovery.core.internal.favorites.SearchFavoritesPersistenceUtil;
import org.eclipse.platform.discovery.integration.internal.plugin.DiscoveryIntegrationPlugin;
import org.eclipse.platform.discovery.integration.internal.plugin.ISlaveControllersConfiguration;
import org.eclipse.platform.discovery.integration.internal.plugin.IViewCustomizationConfiguration;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.ISearchConsoleCustomization;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.api.impl.DefaultSessionIds;
import org.eclipse.platform.discovery.ui.internal.view.ICustomizableView;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.WorkbenchException;
import org.jmock.core.Constraint;

public class DiscoveryIntegrationPluginTest
extends MockObjectTestCase {
    private Mock<IWorkbenchPartReference> wbPartReference;
    private Mock<ISearchConsoleView> consoleView;
    private Mock<ISearchConsoleControllerOutputView> consoleViewOutputController;
    private Mock<ISearchConsoleController> consoleController;
    private TestedIntegrationPlugin plugin;
    private Mock<ISlaveControllersConfiguration> slaveControllersConfig;
    private Mock<ISearchConsoleSlaveController> slaveController;
    private Mock<IContributedAction> contributedAction;
    private Mock<IViewCustomizationConfiguration> viewCustomizationsConfig;
    private Mock<ICustomizableView> customizableView;
    private Mock<ISearchConsoleCustomization> searchConsoleViewCustomization;
    private Mock<IMasterDiscoveryView> masterView;
    private Mock<ILongOperationRunner> operationRunner;
    private Mock<ISearchFavoritesControllerOutputView> favoritesControllerView;
    private Mock<ISearchFavoritesMasterController> searchFavoritesController;
    private Mock<IDiscoveryView<ISearchFavoritesControllerOutputView, ISearchFavoritesMasterController>> searchFavoritesView;
    private Mock<ISearchFavoritesSlaveController> searchFavoritesSlaveController;
    private Mock<ISearchFavoritesViewCustomization> searchFavoritesViewCustomization;

    protected void setUp() throws Exception {
        this.wbPartReference = this.mock(IWorkbenchPartReference.class);
        this.consoleViewOutputController = this.mock(ISearchConsoleControllerOutputView.class);
        this.consoleView = this.mock(ISearchConsoleView.class);
        this.consoleView.stubs().method("getControllerView").will(this.returnValue(this.consoleViewOutputController.proxy()));
        this.consoleController = this.mock(ISearchConsoleController.class);
        this.contributedAction = this.mock(IContributedAction.class);
        this.customizableView = this.mock(ICustomizableView.class);
        this.masterView = this.mock(IMasterDiscoveryView.class);
        this.operationRunner = this.mock(ILongOperationRunner.class);
        this.searchFavoritesView = this.mock(IDiscoveryView.class);
        this.favoritesControllerView = this.mock(ISearchFavoritesControllerOutputView.class);
        this.searchFavoritesView.stubs().method("getControllerView").will(this.returnValue(this.favoritesControllerView.proxy()));
        this.searchFavoritesController = this.mock(ISearchFavoritesMasterController.class);
        this.setupSlaveControllers();
        this.setupViewCustomizations();
        this.plugin = new TestedIntegrationPlugin();
    }

    private void setupSlaveControllers() {
        this.slaveController = this.mock(ISearchConsoleSlaveController.class);
        this.slaveController.stubs().method("createActions").will(this.returnValue(new HashSet<IContributedAction>(Arrays.asList((IContributedAction)this.contributedAction.proxy()))));
        this.searchFavoritesSlaveController = this.mock(ISearchFavoritesSlaveController.class);
        this.searchFavoritesSlaveController.stubs().method("createActions").will(this.returnValue(new HashSet<IContributedAction>(Arrays.asList((IContributedAction)this.contributedAction.proxy()))));
        this.slaveControllersConfig = this.mock(ISlaveControllersConfiguration.class);
        this.slaveControllersConfig.expects(this.atMostOnce()).method("availableSearchConsoleSlaveControllers").will(this.returnValue(Arrays.asList((ISearchConsoleSlaveController)this.slaveController.proxy())));
        this.slaveControllersConfig.expects(this.atMostOnce()).method("availableSearchFavoritesSlaveControllers").will(this.returnValue(Arrays.asList((ISearchFavoritesSlaveController)this.searchFavoritesSlaveController.proxy())));
    }

    private void setupViewCustomizations() {
        this.searchConsoleViewCustomization = this.mock(ISearchConsoleCustomization.class);
        this.searchFavoritesViewCustomization = this.mock(ISearchFavoritesViewCustomization.class);
        this.viewCustomizationsConfig = this.mock(IViewCustomizationConfiguration.class);
        this.viewCustomizationsConfig.expects(this.atMostOnce()).method("availableSearchConsoleCustomizations").will(this.returnValue(Arrays.asList((ISearchConsoleCustomization)this.searchConsoleViewCustomization.proxy())));
        this.viewCustomizationsConfig.expects(this.atMostOnce()).method("availableSearchFavoritesCustomizations").will(this.returnValue(Arrays.asList((ISearchFavoritesViewCustomization)this.searchFavoritesViewCustomization.proxy())));
    }

    public void testPartOpenedInternalWithUnknownView() {
        this.wbPartReference.stubs().method("getId").will(this.returnValue("myid"));
        this.plugin.partOpenedInternal((IWorkbenchPartReference)this.wbPartReference.proxy());
    }

    public void testSearchConsoleOpened() {
        this.wbPartReference.stubs().method("getId").will(this.returnValue("org.eclipse.platform.discovery.ui.internal.view.SearchConsoleView"));
        this.wbPartReference.expects(this.once()).method("getPart").with((Constraint)this.eq(false)).will(this.returnValue(this.mock(IWorkbenchPart.class).proxy()));
        this.customizableView.expects(this.once()).method("registerAction").with((Constraint)this.eq(this.contributedAction.proxy()));
        this.consoleView.expects(this.once()).method("getProgressMonitor").will(this.returnValue(this.mock(IProgressMonitor.class).proxy()));
        this.consoleView.expects(this.once()).method("setEnvironment").with((Constraint)this.isA(IDiscoveryEnvironment.class));
        this.consoleView.expects(this.once()).method("setDefaultSessionId").with((Constraint)this.eq(DefaultSessionIds.mainSearchSessionId));
        this.consoleView.expects(this.once()).method("initializationCompleted");
        this.consoleView.expects(this.once()).method("registerController").with((Constraint)this.same(this.consoleController.proxy()));
        this.customizableView.expects(this.once()).method("registerViewCustomization").with((Constraint)this.eq(this.searchConsoleViewCustomization.proxy()));
        this.customizableView.expects(this.once()).method("setUiContext").with((Constraint)this.isA(IViewUiContext.class));
        this.slaveController.expects(this.once()).method("setMasterController").with((Constraint)this.eq(this.consoleController.proxy()));
        this.searchConsoleViewCustomization.expects(this.once()).method("setMasterView").with((Constraint)this.eq(this.masterView.proxy()));
        this.plugin.partOpenedInternal((IWorkbenchPartReference)this.wbPartReference.proxy());
    }

    public void testSearchFavoritesOpened() {
        this.searchFavoritesView.expects(this.once()).method("setEnvironment").with((Constraint)this.isA(IDiscoveryEnvironment.class));
        this.searchFavoritesView.expects(this.once()).method("registerController").with((Constraint)this.same(this.searchFavoritesController.proxy()));
        this.searchFavoritesView.expects(this.once()).method("initializationCompleted");
        this.wbPartReference.stubs().method("getId").will(this.returnValue("org.eclipse.platform.discovery.ui.internal.view.SearchFavoritesView"));
        this.wbPartReference.expects(this.once()).method("getPart").with((Constraint)this.eq(false)).will(this.returnValue(this.mock(IWorkbenchPart.class).proxy()));
        this.customizableView.expects(this.once()).method("registerAction").with((Constraint)this.eq(this.contributedAction.proxy()));
        this.searchFavoritesView.expects(this.once()).method("getProgressMonitor").will(this.returnValue(this.mock(IProgressMonitor.class).proxy()));
        this.customizableView.expects(this.once()).method("registerViewCustomization").with((Constraint)this.eq(this.searchFavoritesViewCustomization.proxy()));
        this.customizableView.expects(this.once()).method("setUiContext").with((Constraint)this.isA(IViewUiContext.class));
        this.searchFavoritesSlaveController.expects(this.once()).method("setMasterController").with((Constraint)this.eq(this.searchFavoritesController.proxy()));
        this.searchFavoritesViewCustomization.expects(this.once()).method("setMasterView").with((Constraint)this.eq(this.masterView.proxy()));
        this.plugin.partOpenedInternal((IWorkbenchPartReference)this.wbPartReference.proxy());
    }

    public void testCreateFavoritesPersistenceUtilFavoritesViewNotOpened() {
        DiscoveryIntegrationPluginTest.assertTrue((String)"Unexpected util instance", (boolean)(this.plugin.createFavoritesPersistenceUtil() instanceof SearchFavoritesPersistenceUtil));
    }

    public void testCreateFavoritesPersistenceUtilFavoritesViewOpened() throws WorkbenchException, IOException, MementoContentManagerException {
        this.testSearchFavoritesOpened();
        IPersistenceUtil util = this.plugin.createFavoritesPersistenceUtil();
        HashSet<DestinationItemPair> pairs = new HashSet<DestinationItemPair>();
        Mock searchDestination = this.mock(ISearchDestination.class);
        Object item = new Object();
        pairs.add(new DestinationItemPair((ISearchDestination)searchDestination.proxy(), item));
        this.searchFavoritesController.expects(this.once()).method("importData").with(this.arrayWithSingleElementContraint(pairs.iterator().next()));
        util.addItems(pairs, (ILongOperationRunner)this.operationRunner.proxy());
        HashSet<Object> itemsToDelete = new HashSet<Object>(Arrays.asList(item));
        this.searchFavoritesController.expects(this.once()).method("deleteItems").with((Constraint)this.eq(itemsToDelete));
        util.deleteItems(itemsToDelete, (ILongOperationRunner)this.operationRunner.proxy());
    }

    private Constraint arrayWithSingleElementContraint(final Object element) {
        return new Constraint(){

            public StringBuffer describeTo(StringBuffer buffer) {
                return buffer;
            }

            public boolean eval(Object o) {
                if (!(o instanceof Object[])) {
                    return false;
                }
                Object[] arr = (Object[])o;
                return arr.length == 1 && arr[0].equals(element);
            }
        };
    }

    private class TestedIntegrationPlugin
    extends DiscoveryIntegrationPlugin {
        private TestedIntegrationPlugin() {
        }

        protected ISearchConsoleController createSearchConsoleController(ISearchConsoleControllerOutputView view, ISearchProviderConfiguration searchProviderConfig, IDiscoveryEnvironment environment) {
            DiscoveryIntegrationPluginTest.assertTrue((String)"Unexpected console view", (view == DiscoveryIntegrationPluginTest.this.consoleViewOutputController.proxy() ? 1 : 0) != 0);
            return (ISearchConsoleController)DiscoveryIntegrationPluginTest.this.consoleController.proxy();
        }

        protected ISearchFavoritesMasterController createSearchFavoritesController(ISearchFavoritesControllerOutputView view, IDiscoveryEnvironment env) {
            DiscoveryIntegrationPluginTest.assertTrue((String)"Unexpected console view", (view == DiscoveryIntegrationPluginTest.this.favoritesControllerView.proxy() ? 1 : 0) != 0);
            return (ISearchFavoritesMasterController)DiscoveryIntegrationPluginTest.this.searchFavoritesController.proxy();
        }

        protected ISearchConsoleView getBusinessViewFromPart(IWorkbenchPart part) {
            return (ISearchConsoleView)DiscoveryIntegrationPluginTest.this.consoleView.proxy();
        }

        protected IDiscoveryView<ISearchFavoritesControllerOutputView, ISearchFavoritesMasterController> getSearchFavoritesViewFromPart(IWorkbenchPart part) {
            return (IDiscoveryView)DiscoveryIntegrationPluginTest.this.searchFavoritesView.proxy();
        }

        protected ISlaveControllersConfiguration slaveControllersConfig() {
            return (ISlaveControllersConfiguration)DiscoveryIntegrationPluginTest.this.slaveControllersConfig.proxy();
        }

        protected IViewCustomizationConfiguration viewCustomizationsConfig() {
            return (IViewCustomizationConfiguration)DiscoveryIntegrationPluginTest.this.viewCustomizationsConfig.proxy();
        }

        protected ICustomizableView getCustomizableViewFromPart(IWorkbenchPart part) {
            return (ICustomizableView)DiscoveryIntegrationPluginTest.this.customizableView.proxy();
        }

        protected IMasterDiscoveryView getMasterViewFromPart(IWorkbenchPart wbPart) {
            return (IMasterDiscoveryView)DiscoveryIntegrationPluginTest.this.masterView.proxy();
        }

        protected ILongOperationRunner longOperationRunner(IProgressMonitor monitor) {
            return (ILongOperationRunner)DiscoveryIntegrationPluginTest.this.operationRunner.proxy();
        }

        protected void partOpenedInternal(IWorkbenchPartReference partRef) {
            super.partOpenedInternal(partRef);
        }
    }
}

