/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import junit.framework.Assert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.examples.providers.RemoteStoreContentProvider;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStore;
import org.eclipse.core.resources.semantic.test.TestsContentProviderBase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.junit.After;
import org.junit.Before;

public class TestRemoteStoreContentProvider
extends TestsContentProviderBase {
    public TestRemoteStoreContentProvider() {
        super(false, "TestRemoteStoreContentProvider", RemoteStoreContentProvider.class.getName());
    }

    public RemoteFile getRemoteFile() {
        RemoteStore store = (RemoteStore)this.testProject.getAdapter(RemoteStore.class);
        return (RemoteFile)store.getItemByPath((IPath)new Path("Folder1/File1"));
    }

    @Before
    public void beforeMethod() throws Exception {
        String[] roots;
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        if (project.exists()) {
            throw new IllegalStateException("Project exists");
        }
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProjectDescription description = workspace.newProjectDescription(TestRemoteStoreContentProvider.this.projectName);
                try {
                    description.setLocationURI(new URI("semanticfs:/" + TestRemoteStoreContentProvider.this.projectName));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                project.create(description, monitor);
                project.open(monitor);
                RepositoryProvider.map((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                ISemanticProject spr = (ISemanticProject)project.getAdapter(ISemanticProject.class);
                RemoteStore store = (RemoteStore)project.getAdapter(RemoteStore.class);
                store.reset();
                RemoteFolder f1 = store.getRootFolder().addFolder("Folder1");
                f1.addFolder("Folder11");
                try {
                    f1.addFile("File1", "Hello".getBytes("UTF-8"), store.newTime());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                store.serialize(monitor);
                HashMap<QualifiedName, String> properties = new HashMap<QualifiedName, String>();
                properties.put(TEMPLATE_PROP, "World");
                spr.addFolder("root", TestRemoteStoreContentProvider.this.providerName, properties, TestRemoteStoreContentProvider.this.options, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        workspace.run(myRunnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        this.testProject = project;
        String projectName1 = this.testProject.getName();
        String[] stringArray = roots = ((ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs")).getRootNames();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            if (root.equals(projectName1)) {
                return;
            }
            ++n2;
        }
        Assert.fail((String)"Project should be in the list of root names");
    }

    @After
    public void afterMethod() throws Exception {
        RemoteStore store = (RemoteStore)this.testProject.getAdapter(RemoteStore.class);
        store.reset();
        store.serialize(null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        this.testProject = null;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.delete(true, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }
}

