/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.internal.view.dnd.ISourceDndInteractionEvent;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.DragSrcInteractionListener;
import org.eclipse.platform.discovery.ui.test.unit.internal.dnd.DndTestFixture;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.jmock.core.Constraint;

public class DragSrcInteractionListenerTest
extends MockObjectTestCase {
    private Mock<DragSrcInteractionListener.ISelectionObtainer> selectionObtainer;
    private IStructuredSelection selection;
    private DragSrcInteractionListener listener;
    private Object item1;
    private Object item2;
    private Object item3;
    private Transfer transfer;
    private Mock<DragSrcInteractionListener.ITransferDataSetter<Transfer>> transferSetter;
    private Mock<DndTestFixture.IRunnableWithResult<Boolean, TransferData>> supportedDatasRunnable;
    private DndTestFixture.TestDNDInteractionEvent dragSourceEvent;
    private Mock<IErrorHandler> errorHandler;

    protected void setUp() throws Exception {
        this.selectionObtainer = this.mock(DragSrcInteractionListener.ISelectionObtainer.class);
        this.item1 = new Object();
        this.item2 = new Object();
        this.item3 = new Object();
        this.selection = new StructuredSelection(new Object[]{this.item1, this.item2, this.item3});
        this.selectionObtainer.stubs().method("getSelection").will(this.returnValue(this.selection));
        this.supportedDatasRunnable = this.mock(DndTestFixture.IRunnableWithResult.class);
        this.transfer = new DndTestFixture.TestTransfer((DndTestFixture.IRunnableWithResult)this.supportedDatasRunnable.proxy());
        this.transferSetter = this.mock(DragSrcInteractionListener.ITransferDataSetter.class, "Transfer setter");
        this.transferSetter.stubs().method("getTransfer").will(this.returnValue(this.transfer));
        this.errorHandler = this.mock(IErrorHandler.class);
        DragSrcInteractionListener.ITransferDataSetter[] transfers = new DragSrcInteractionListener.ITransferDataSetter[]{(DragSrcInteractionListener.ITransferDataSetter)this.transferSetter.proxy()};
        this.listener = new DragSrcInteractionListener((DragSrcInteractionListener.ISelectionObtainer)this.selectionObtainer.proxy(), transfers, (IErrorHandler)this.errorHandler.proxy());
        this.dragSourceEvent = new DndTestFixture.TestDNDInteractionEvent();
    }

    public void testDragStart() {
        this.transferSetter.expects(this.once()).method("dragStarted").with((Constraint)this.eq(this.selection), (Constraint)this.eq(this.dragSourceEvent));
        this.listener.start((ISourceDndInteractionEvent)this.dragSourceEvent);
        DragSrcInteractionListenerTest.assertTrue((String)"doit should be set to true", (boolean)this.dragSourceEvent.getDoIt());
    }

    public void testDragStartWithEmptySelection() {
        StructuredSelection sel = new StructuredSelection();
        this.selectionObtainer.stubs().method("getSelection").will(this.returnValue(sel));
        this.listener.start((ISourceDndInteractionEvent)this.dragSourceEvent);
        DragSrcInteractionListenerTest.assertFalse((String)"doit should be set to false for empty selection", (boolean)this.dragSourceEvent.getDoIt());
    }

    public void testDragSetDataWithSupportedType() {
        this.supportedDatasRunnable.stubs().method("run").withAnyArguments().will(this.returnValue(true));
        this.transferSetter.expects(this.once()).method("setData").with((Constraint)this.eq(this.selection), (Constraint)this.eq(this.dragSourceEvent));
        this.listener.process((ISourceDndInteractionEvent)this.dragSourceEvent);
    }

    public void testDragSetDataWithUnsupportedType() {
        this.supportedDatasRunnable.stubs().method("run").withAnyArguments().will(this.returnValue(false));
        this.listener.process((ISourceDndInteractionEvent)this.dragSourceEvent);
    }

    public void testGetTransfers() {
        DragSrcInteractionListenerTest.assertEquals((String)"One transfer expected", (int)1, (int)this.listener.getTransfers().length);
        DragSrcInteractionListenerTest.assertTrue((String)"One transfer expected", (this.listener.getTransfers()[0] == this.transfer ? 1 : 0) != 0);
    }
}

