/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ControlElement;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.widgets.ImageBasedFrame;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSSRenderingUtils {
    private Map<Image, Image> rotatedImageMap = new HashMap<Image, Image>();

    public Control frameMeIfPossible(Control toFrame, String classId, boolean vertical, boolean draggable) {
        Integer[] frameInts = new Integer[4];
        Image frameImage = this.createImage(toFrame, classId, "frame-image", frameInts);
        if (vertical && frameImage != null) {
            frameImage = this.rotateImage(toFrame.getDisplay(), frameImage, frameInts);
        }
        Image handleImage = this.createImage(toFrame, classId, "handle-image", null);
        if (vertical && handleImage != null) {
            handleImage = this.rotateImage(toFrame.getDisplay(), handleImage, null);
        }
        if (frameImage != null) {
            ImageBasedFrame frame = new ImageBasedFrame(toFrame.getParent(), toFrame, vertical, draggable);
            frame.setImages(frameImage, frameInts, handleImage);
            return frame;
        }
        return toFrame;
    }

    private Image rotateImage(Display display, Image image, Integer[] frameInts) {
        if (frameInts != null) {
            int tmp = frameInts[0];
            frameInts[0] = frameInts[2];
            frameInts[2] = tmp;
            tmp = frameInts[1];
            frameInts[1] = frameInts[3];
            frameInts[3] = tmp;
        }
        if (this.rotatedImageMap.get(image) != null) {
            return this.rotatedImageMap.get(image);
        }
        Rectangle bounds = image.getBounds();
        ImageData imageData = new ImageData(bounds.height, bounds.width, 32, new PaletteData(0xFF0000, 65280, 255));
        Image rotatedImage = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)rotatedImage);
        RGB rgb = new RGB(125, 0, 0);
        Color offRed = new Color((Device)display, rgb);
        gc.setBackground(offRed);
        gc.fillRectangle(0, 0, bounds.height, bounds.width);
        Transform t = new Transform((Device)display);
        int w = image.getBounds().height;
        int offset = 0;
        t.translate((float)(w - offset), 0.0f);
        t.rotate(90.0f);
        gc.setTransform(t);
        gc.drawImage(image, 0, 0);
        gc.dispose();
        t.dispose();
        offRed.dispose();
        ImageData alphaData = rotatedImage.getImageData();
        rotatedImage.dispose();
        int transparentPix = alphaData.palette.getPixel(rgb);
        int i = 0;
        while (i < alphaData.width) {
            int j = 0;
            while (j < alphaData.height) {
                if (alphaData.getPixel(i, j) != transparentPix) {
                    alphaData.setAlpha(i, j, 255);
                }
                ++j;
            }
            ++i;
        }
        rotatedImage = new Image((Device)display, alphaData);
        this.rotatedImageMap.put(image, rotatedImage);
        return rotatedImage;
    }

    public CSSValue getCSSValue(Control styleControl, String className, String attributeName) {
        CSSStyleDeclaration styleDeclarations;
        CSSEngine csseng = WidgetElement.getEngine((Widget)styleControl);
        if (csseng == null) {
            return null;
        }
        ControlElement tempEment = (ControlElement)csseng.getElement((Object)styleControl);
        if (tempEment == null) {
            return null;
        }
        if (className != null) {
            WidgetElement.setCSSClass((Widget)styleControl, (String)className);
        }
        if ((styleDeclarations = csseng.getViewCSS().getComputedStyle((Element)tempEment, "")) == null) {
            return null;
        }
        return styleDeclarations.getPropertyCSSValue(attributeName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image createImage(Control styleControl, String classId, String attName, Integer[] frameInts) {
        CSSStyleDeclaration styleDeclarations;
        Image image = null;
        CSSEngine csseng = WidgetElement.getEngine((Widget)styleControl);
        if (csseng == null) {
            return null;
        }
        ControlElement tempEment = (ControlElement)csseng.getElement((Object)styleControl);
        if (tempEment == null) {
            return null;
        }
        if (classId != null) {
            ControlElement.setCSSClass((Widget)styleControl, (String)classId);
        }
        if ((styleDeclarations = csseng.getViewCSS().getComputedStyle((Element)tempEment, "")) == null) {
            return null;
        }
        CSSValue imagePath = styleDeclarations.getPropertyCSSValue(attName);
        if (imagePath == null) {
            return null;
        }
        if (imagePath == null) return image;
        if (imagePath.getCssValueType() != 1) return image;
        try {
            image = (Image)csseng.convert(imagePath, Image.class, (Object)styleControl.getDisplay());
            if (image == null) return image;
            if (frameInts == null) return image;
            CSSValue value = styleDeclarations.getPropertyCSSValue("frame-cuts");
            if (value.getCssValueType() != 2) return image;
            CSSValueList valueList = (CSSValueList)value;
            if (valueList.getLength() != 4) {
                return null;
            }
            int i = 0;
            while (true) {
                if (i >= valueList.getLength()) {
                    return image;
                }
                CSSValue val = valueList.item(i);
                if (val.getCssValueType() != 1) return null;
                if (((CSSPrimitiveValue)val).getPrimitiveType() != 5) return null;
                frameInts[i] = (int)((CSSPrimitiveValue)val).getFloatValue((short)5);
                ++i;
            }
        }
        catch (Exception exception) {}
        return image;
    }
}

