/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.net.URI;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.examples.AddDemoRESTResourcePage;
import org.eclipse.core.resources.semantic.examples.HandlerUtilities;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.resources.semantic.examples.SemanticResourcesPluginExamples;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class HandleAddRestResource
extends HandlerUtilities {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISemanticFolder sFolder = (ISemanticFolder)this.getSelectedObject(event, ISemanticFolder.class, true);
        if (sFolder == null) {
            this.showPopup(Messages.HandleAddFromRemote_Error_XGRP, Messages.HandleAddFromRemote_NotSemantic_XMSG);
            return null;
        }
        MyWizard wizard = new MyWizard(sFolder);
        new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard).open();
        return null;
    }

    private static final class MyWizard
    extends Wizard {
        final ISemanticFolder myFolder;

        MyWizard(ISemanticFolder folder) {
            this.myFolder = folder;
        }

        public void addPages() {
            this.addPage((IWizardPage)new AddDemoRESTResourcePage(this.myFolder));
        }

        public boolean performFinish() {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            final String resourceName = ((AddDemoRESTResourcePage)this.getPage(AddDemoRESTResourcePage.NAME)).getResourceName();
            final String resourceURL = ((AddDemoRESTResourcePage)this.getPage(AddDemoRESTResourcePage.NAME)).getResourceURL();
            IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    MyWizard.this.myFolder.addFile(resourceName, URI.create(resourceURL), 0, monitor);
                    MyWizard.this.myFolder.getAdaptedResource().refreshLocal(2, monitor);
                }
            };
            try {
                workspace.run(myRunnable, (ISchedulingRule)workspace.getRoot(), 1, null);
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewDemoRESTResourceWizard_Error_XGRP, (String)e.getMessage());
                SemanticResourcesPluginExamples.getDefault().getLog().log(e.getStatus());
                return false;
            }
            return true;
        }
    }
}

