/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.commands;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.e4.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.e4.xwt.tools.ui.designer.core.style.StyleGroup;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.StringUtil;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.commands.Command;

public class SetStyleCommand
extends Command {
    private XamlNode parent;
    private String newStyle;
    private StyleGroup group;
    private boolean remove;
    private Command delegate;

    public SetStyleCommand(XamlNode parent, String newStyle) {
        this.parent = parent;
        this.newStyle = newStyle;
    }

    public SetStyleCommand(XamlNode parent, String newStyle, StyleGroup group) {
        this(parent, newStyle);
        this.group = group;
    }

    public SetStyleCommand(XamlNode parent, String newStyle, boolean remove) {
        this(parent, newStyle);
        this.remove = remove;
    }

    public void setGroup(StyleGroup group) {
        this.group = group;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean canExecute() {
        return this.parent != null && this.newStyle != null;
    }

    public boolean canUndo() {
        return this.delegate != null && this.delegate.canUndo();
    }

    private Command createCommand(String newStyle) {
        return new ApplyAttributeSettingCommand(this.parent, "style", "http://www.eclipse.org/xwt", newStyle);
    }

    private Command createDelegate() {
        XamlAttribute attribute = this.parent.getAttribute("style", "http://www.eclipse.org/xwt");
        if (attribute == null || attribute.getValue() == null) {
            return this.createCommand(this.newStyle);
        }
        String value = attribute.getValue();
        ArrayList<String> oldValues = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(value, "|");
        while (stk.hasMoreTokens()) {
            oldValues.add(stk.nextToken().trim().toUpperCase());
        }
        if (oldValues.isEmpty()) {
            return this.createCommand(this.newStyle);
        }
        if (this.group != null && !"default".equals(this.group.getGroupName())) {
            String[] styles;
            String[] stringArray = styles = this.group.getStyles();
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (oldValues.contains(str)) {
                    oldValues.remove(str);
                }
                if (oldValues.contains("SWT." + str)) {
                    oldValues.remove("SWT." + str);
                }
                ++n2;
            }
            oldValues.add(this.newStyle);
            String newStyleValue = StringUtil.format((Object[])oldValues.toArray(new String[oldValues.size()]), (String)"|");
            return this.createCommand(newStyleValue);
        }
        if (this.remove) {
            if (oldValues.contains(this.newStyle)) {
                oldValues.remove(this.newStyle);
            }
            if (oldValues.contains("SWT." + this.newStyle)) {
                oldValues.remove("SWT." + this.newStyle);
            }
            String newStyleValue = StringUtil.format((Object[])oldValues.toArray(new String[oldValues.size()]), (String)"|");
            return this.createCommand(newStyleValue);
        }
        if (oldValues.contains(this.newStyle) || oldValues.contains("SWT." + this.newStyle)) {
            return null;
        }
        String styleValue = String.valueOf(value) + "|" + this.newStyle;
        return this.createCommand(styleValue);
    }

    public void execute() {
        this.delegate = this.createDelegate();
        if (this.delegate != null && this.delegate.canExecute()) {
            this.delegate.execute();
        }
    }
}

