/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventUtils;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.util.JSONObject;
import org.eclipse.e4.demo.e4photo.Exif;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.osgi.service.event.EventAdmin;

public class ExifTable {
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private WritableList inputList = new WritableList();
    private IContainer input;
    private String persistedState;
    public static final String EVENT_NAME = "org/eclipse/e4/demo/e4photo/exif";
    @Inject
    private Composite parent;
    @Inject
    private Logger logger;
    @Inject
    private EventAdmin eventAdmin;
    private TableViewer viewer;

    @Inject
    @Optional
    void setSelection(@Named(value="org.eclipse.ui.selection") IResource selection) {
        if (selection == null) {
            return;
        }
        IContainer newInput = selection instanceof IContainer ? (IContainer)selection : selection.getParent();
        if (newInput == this.input) {
            return;
        }
        this.input = newInput;
        this.inputList.clear();
        try {
            IResource[] members = this.input.members();
            int i = 0;
            while (i < members.length) {
                block17: {
                    IResource resource = members[i];
                    if (resource.getType() == 1) {
                        InputStream contents = ((IFile)resource).getContents();
                        try {
                            try {
                                Exif exif = new Exif(resource.getLocationURI(), contents);
                                this.inputList.add((Object)exif);
                            }
                            catch (Exception e) {
                                this.logger.warn(((IFile)resource).getFullPath() + ": " + e.getMessage());
                                try {
                                    contents.close();
                                }
                                catch (IOException e2) {
                                    this.logger.warn((Throwable)e2, "Could not close stream");
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                contents.close();
                            }
                            catch (IOException e) {
                                this.logger.warn((Throwable)e, "Could not close stream");
                            }
                            throw throwable;
                        }
                        try {
                            contents.close();
                        }
                        catch (IOException e) {
                            this.logger.warn((Throwable)e, "Could not close stream");
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Inject
    @Optional
    void setPersistedState(@Named(value="persistedState") String persistedState) {
        this.persistedState = persistedState;
        this.changeSupport.firePropertyChange("persistedState", this.persistedState, this.persistedState);
    }

    @PostConstruct
    void init() {
        this.parent.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(this.parent, 68356);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setData("org.eclipse.e4.ui.css.id", (Object)"exif");
        this.viewer.getTable().setData("org.eclipse.e4.ui.css.CssClassName", (Object)"properties");
        final JSONObject state = this.persistedState == null ? new JSONObject() : JSONObject.deserialize((String)this.persistedState);
        String[] columnNames = new String[]{"name", "make", "model", "orientation", "software", "timestamp", "gpsLatitude", "gpsLongitude", "exposure", "iso", "aperture", "exposureComp", "flash", "width", "height", "focalLength", "whiteBalance", "lightSource", "exposureProgram"};
        int i = 0;
        while (i < columnNames.length) {
            TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
            final TableColumn c = column.getColumn();
            final String name = columnNames[i];
            c.setText(name);
            String width = state.getString(name);
            if (width != null) {
                c.setWidth(Integer.parseInt(width));
            } else {
                c.pack();
            }
            c.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    state.set(name, String.valueOf(c.getWidth()));
                    ExifTable.this.setPersistedState(state.serialize());
                }
            });
            ++i;
        }
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((StructuredSelection)event.getSelection()).getFirstElement();
                if (ExifTable.this.eventAdmin != null) {
                    EventUtils.post((EventAdmin)ExifTable.this.eventAdmin, (String)ExifTable.EVENT_NAME, (Object)selected);
                }
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(PojoObservables.observeMaps((IObservableSet)contentProvider.getKnownElements(), Exif.class, (String[])columnNames)));
        this.viewer.setInput((Object)this.inputList);
    }

    @Focus
    void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void dispose() {
    }
}

