/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.selector;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.platform.discovery.core.internal.selectors.IStartableItemsSelector;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SubdestinationsSelector
extends ToolTip
implements IStartableItemsSelector<ISearchSubdestination> {
    private final Set<ISearchSubdestination> subDestinations;
    private final Point showPoint;
    private final LinkedHashMap<Button, ISearchSubdestination> allButtons;
    private ManagedForm _managedForm;

    public SubdestinationsSelector(Control control, int style, Set<ISearchSubdestination> subDestinations, Point showPoint) {
        super(control, style, true);
        this.setHideOnMouseDown(false);
        this.subDestinations = Collections.unmodifiableSet(subDestinations);
        this.showPoint = showPoint;
        this.allButtons = new LinkedHashMap();
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        ManagedForm managedForm = this.newManagedForm(parent);
        Composite formComposite = managedForm.getForm().getBody();
        FormToolkit formToolkit = managedForm.getToolkit();
        formComposite.setLayout((Layout)new GridLayout(1, false));
        for (final ISearchSubdestination subDest : this.sortSubdestinations(this.subDestinations)) {
            Button subdestButton = formToolkit.createButton(formComposite, subDest.getDisplayName(), 32);
            this.allButtons.put(subdestButton, subDest);
            subdestButton.setSelection(this.isSubdestinationActive(subDest));
            subdestButton.addSelectionListener((SelectionListener)new SubdestinationCheckboxSelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!$assertionsDisabled && !(e.getSource() instanceof Button)) {
                        throw new AssertionError();
                    }
                    Button b = (Button)e.getSource();
                    SubdestinationsSelector.this.handleSelection(subDest, b.getSelection());
                    if (b.getSelection()) {
                        for (Map.Entry curr : SubdestinationsSelector.this.allButtons.entrySet()) {
                            if (SubdestinationsSelector.this.isSubdestinationActive((ISearchSubdestination)curr.getValue()) || ((Button)curr.getKey()).equals(b)) continue;
                            ((Button)curr.getKey()).setSelection(false);
                        }
                    }
                }
            });
        }
        return managedForm.getForm();
    }

    protected void setFocus() {
        Iterator<Button> iter = this.allButtons.keySet().iterator();
        iter.next().setFocus();
    }

    protected Collection<ISearchSubdestination> sortSubdestinations(Set<ISearchSubdestination> subdestinations) {
        ISearchSubdestination[] sortedSubdestinations = new ISearchSubdestination[subdestinations.size()];
        Arrays.sort(subdestinations.toArray(sortedSubdestinations), new Comparator<ISearchSubdestination>(){

            @Override
            public int compare(ISearchSubdestination o1, ISearchSubdestination o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return Arrays.asList(sortedSubdestinations);
    }

    public void select() {
        this.show(this.showPoint);
        this.setFocus();
    }

    protected abstract boolean isSubdestinationActive(ISearchSubdestination var1);

    private ManagedForm newManagedForm(Composite parent) {
        this.disposeCurrentForm();
        this._managedForm = new ManagedForm(parent);
        return this._managedForm;
    }

    private void disposeCurrentForm() {
        if (this._managedForm != null && !this._managedForm.getForm().isDisposed()) {
            this._managedForm.dispose();
        }
    }

    public void dispose() {
        this.disposeCurrentForm();
    }

    private abstract class SubdestinationCheckboxSelectionListener
    implements SelectionListener {
        private SubdestinationCheckboxSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

