/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal;

import org.eclipse.platform.discovery.ui.internal.SlidingCompositeStatePainter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HorizontalStatePainter
extends SlidingCompositeStatePainter {
    public HorizontalStatePainter(FormToolkit formToolkit) {
        super(formToolkit);
    }

    @Override
    public int[] getArrowDownPolygon(Rectangle clientArea) {
        int topAngleX = clientArea.width / 2;
        int topAngleY = clientArea.y + (clientArea.height / 2 - 5);
        int botomY = topAngleY + 5;
        int[] arrowDown = new int[]{topAngleX - 5, topAngleY, topAngleX - 5, topAngleY + 10, topAngleX, botomY};
        return arrowDown;
    }

    @Override
    public int[] getArrowUpPolygon(Rectangle clientArea) {
        int topAngleX = clientArea.width / 2;
        int topAngleY = clientArea.y + clientArea.height / 2;
        int leftAngleX = topAngleX - 5;
        int botomY = topAngleY + 5;
        int[] arrowUp = new int[]{topAngleX, topAngleY, leftAngleX + 10, botomY - 10, leftAngleX + 10, botomY};
        return arrowUp;
    }

    @Override
    public void printSliderButtonDown(PaintEvent e, Rectangle clientArea) {
        int X_COORD = this.getHorizontalBeginPosition(clientArea);
        int Y_COORD = this.getVerticalBeginPosition(clientArea);
        int HEIGHT = this.getVerticalSize(clientArea);
        int WIDTH = this.getHorizontalSize(clientArea);
        int HALF_HEIGHT = HEIGHT / 2;
        int HALF_WIDTH = WIDTH / 2;
        e.gc.setForeground(this.getSliderBorderColor());
        e.gc.drawRoundRectangle(X_COORD, Y_COORD, HALF_WIDTH, HEIGHT, 6, 6);
        e.gc.drawRoundRectangle(X_COORD, HALF_HEIGHT - 15, WIDTH - 5, 30, 10, 10);
        e.gc.setBackground(this.getSliderFillColor());
        e.gc.fillRoundRectangle(X_COORD + 1, Y_COORD + 2, HALF_WIDTH - 3, HEIGHT - 2 - 2, 6, 6);
        e.gc.fillRectangle(X_COORD + 2, Y_COORD + 1 + 2, HALF_WIDTH - 6, HEIGHT - 6);
        e.gc.fillRoundRectangle(X_COORD + 2, HALF_HEIGHT - 15 + 1 + 2, HALF_WIDTH, 25, 4, 4);
        e.gc.setForeground(this.getUnderBorderColor());
        e.gc.setLineWidth(2);
        e.gc.drawLine(HALF_WIDTH - 1, Y_COORD + 2, HALF_WIDTH - 1, HALF_HEIGHT - 15 + 1);
        e.gc.drawLine(HALF_WIDTH - 1, HALF_HEIGHT + 15, HALF_WIDTH - 1, HEIGHT - 2);
        e.gc.drawLine(HALF_WIDTH + 2, HALF_HEIGHT - 15 + 2, HALF_WIDTH, HALF_HEIGHT - 15 + 2);
        e.gc.drawLine(HALF_WIDTH + 2, HALF_HEIGHT + 15 - 1, HALF_WIDTH, HALF_HEIGHT + 15 - 1);
        e.gc.setForeground(this.getSliderBorderColor());
        e.gc.setLineWidth(1);
        e.gc.setBackground(this.getTriangleColor());
        e.gc.drawLine(X_COORD + 1, Y_COORD, X_COORD + 1, HEIGHT);
        e.gc.fillPolygon(this.getArrowDownPolygon(clientArea));
    }

    @Override
    public void printSliderButtonUp(PaintEvent e, Rectangle clientArea) {
        int X_COORD = this.getHorizontalBeginPosition(clientArea);
        int Y_COORD = this.getVerticalBeginPosition(clientArea);
        int HEIGHT = this.getVerticalSize(clientArea);
        int WIDTH = this.getHorizontalSize(clientArea);
        int HALF_HEIGHT = HEIGHT / 2;
        int HALF_WIDTH = WIDTH / 2;
        e.gc.setForeground(this.getSliderBorderColor());
        e.gc.drawRoundRectangle(HALF_WIDTH, Y_COORD, HALF_WIDTH, HEIGHT - 1, 6, 6);
        e.gc.drawRoundRectangle(X_COORD + 5, HALF_HEIGHT - 15, WIDTH - 5, 30, 10, 10);
        e.gc.setBackground(this.getSliderFillColor());
        e.gc.fillRoundRectangle(HALF_WIDTH + 1 + 2, Y_COORD + 2, WIDTH - 2 - 4, HEIGHT - 2 - 2, 6, 6);
        e.gc.fillRoundRectangle(X_COORD + 5 + 1 + 2, HALF_HEIGHT - 15 + 1 + 2, WIDTH - 5 - 4 - 1, 25, 4, 4);
        e.gc.setForeground(this.getUnderBorderColor());
        e.gc.setLineWidth(2);
        e.gc.drawLine(HALF_WIDTH + 2, Y_COORD + 2, HALF_WIDTH + 2, HALF_HEIGHT - 15 + 1);
        e.gc.drawLine(HALF_WIDTH + 2, HALF_HEIGHT + 15, HALF_WIDTH + 2, HEIGHT - 2);
        e.gc.drawLine(HALF_WIDTH + 2, HALF_HEIGHT - 15 + 2, HALF_WIDTH, HALF_HEIGHT - 15 + 2);
        e.gc.drawLine(HALF_WIDTH + 2, HALF_HEIGHT + 15 - 1, HALF_WIDTH, HALF_HEIGHT + 15 - 1);
        e.gc.setForeground(this.getSliderBorderColor());
        e.gc.setLineWidth(1);
        e.gc.setBackground(this.getTriangleColor());
        e.gc.drawLine(WIDTH - 1, Y_COORD, WIDTH - 1, HEIGHT);
        e.gc.fillPolygon(this.getArrowUpPolygon(clientArea));
    }

    @Override
    public void arrangeControls(FormData hideButtonFormData, FormData sashFormData, FormData upperScrolledCompositeFormData, FormData bottomCompositeFormData, int targetPosition, int buttonHeight) {
        hideButtonFormData.left = upperScrolledCompositeFormData.right = new FormAttachment(0, targetPosition - buttonHeight);
        sashFormData.left = hideButtonFormData.right;
        sashFormData.width = 2;
        bottomCompositeFormData.left = sashFormData.right = new FormAttachment(0, targetPosition + 2);
    }

    @Override
    public void arrangeControlsOnUpperVisibilityOff(FormData hideButtonFormData, FormData bottomCompositeFormData, int buttonHeight) {
        hideButtonFormData.left = new FormAttachment(0, 0);
        bottomCompositeFormData.left = hideButtonFormData.right = new FormAttachment(0, buttonHeight);
    }

    @Override
    public void adjustControlsLayoutData(FormData upperScrolledCompositeData, FormData hideButtonData, FormData sashData, FormData bottomCompositeData, Canvas hideButton, int buttonHeight) {
        upperScrolledCompositeData.right = new FormAttachment((Control)hideButton);
        sashData.width = 2;
        hideButtonData.width = buttonHeight;
        bottomCompositeData.right = new FormAttachment(100, 0);
    }
}

