/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.api.impl;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ErrorHandler
implements IErrorHandler {
    public void handleException(Exception exc) {
        String msgAndHint = MessageFormat.format(DiscoveryUIMessages.ErrorHandler_SentenceCombiner, DiscoveryUIMessages.ErrorHandler_UNEXPECTED_ERROR_MSG, DiscoveryUIMessages.ErrorHandler_SEE_LOG_HINT_MSG);
        this.logger().logError(exc.getMessage(), (Throwable)exc);
        this.showError(null, msgAndHint);
    }

    protected ILogger logger() {
        return Logger.instance();
    }

    private void showErrorMessageInDialog(final String dialogTitle, final String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorMsgDialog errDialog = new ErrorMsgDialog(null, dialogTitle, message);
                errDialog.open();
            }
        });
    }

    public void showError(String title, String errorMessage) {
        String effectiveTitle = title != null ? title : DiscoveryUIMessages.ErrorHandler_DIALOG_TITLE;
        this.showErrorMessageInDialog(effectiveTitle, errorMessage);
    }

    private class ErrorMsgDialog
    extends MessageDialog {
        final String messageToDisplay;

        public ErrorMsgDialog(Shell parentShell, String dialogTitle, String dialogMessage) {
            super(parentShell, dialogTitle, null, null, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.messageToDisplay = dialogMessage;
        }

        protected Control createMessageArea(Composite composite) {
            composite.setLayout((Layout)new GridLayout(2, false));
            Control control = super.createMessageArea(composite);
            Text messageText = new Text(composite, 66);
            messageText.setText(this.messageToDisplay);
            messageText.setEditable(false);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageText);
            return control;
        }

        public int open() {
            this.setShellStyle(this.getShellStyle() | 0x10000000);
            return super.open();
        }
    }
}

