/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.xp.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.api.IConflict;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchSubdestinationExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;

public class SearchSubdestinationExtensionParser
extends AbstractExtensionPointParser
implements ISearchSubdestinationExtensionParser {
    private static final String XP_ID = "org.eclipse.platform.discovery.runtime.searchsubdestinations";
    private static final String XP_ELEMENT_NAME = "subdestination";
    private static final String CATEGORY_ID_ATTR = "categoryid";
    private static final String DISPLAY_NAME_ATTR = "displayname";
    private static final String ID_ATTR = "id";
    private static final String OBJECT_ATTR = "objecttypeid";
    private static final String DEFAULT_SELECTED_ATTR = "defaultSelected";
    private static final String CONFLICT_ELEMENT_NAME = "conflict";
    private static final String CONF_SUBID_ATTR_NAME = "conflictingSubdID";

    public SearchSubdestinationExtensionParser() {
        super(Platform.getExtensionRegistry(), XP_ID, XP_ELEMENT_NAME);
    }

    @Override
    public Set<ISearchSubdestination> readContributions() {
        HashSet<ISearchSubdestination> result = new HashSet<ISearchSubdestination>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            result.add(this.createSubdestination(element));
        }
        return result;
    }

    private ISearchSubdestination createSubdestination(final IConfigurationElement element) {
        return new ISearchSubdestination(){

            @Override
            public String getDestinationCategoryId() {
                return element.getAttribute(SearchSubdestinationExtensionParser.CATEGORY_ID_ATTR);
            }

            @Override
            public String getObjectTypeId() {
                return element.getAttribute(SearchSubdestinationExtensionParser.OBJECT_ATTR);
            }

            @Override
            public String getDisplayName() {
                return element.getAttribute(SearchSubdestinationExtensionParser.DISPLAY_NAME_ATTR);
            }

            @Override
            public String getId() {
                return element.getAttribute(SearchSubdestinationExtensionParser.ID_ATTR);
            }

            @Override
            public Set<IConflict> getConflictingSubd() {
                HashSet<IConflict> retVal = new HashSet<IConflict>();
                IConfigurationElement[] iConfigurationElementArray = element.getChildren(SearchSubdestinationExtensionParser.CONFLICT_ELEMENT_NAME);
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final IConfigurationElement curr = iConfigurationElementArray[n2];
                    retVal.add(new IConflict(){

                        @Override
                        public String getconflictingSubdID() {
                            return curr.getAttribute(SearchSubdestinationExtensionParser.CONF_SUBID_ATTR_NAME);
                        }
                    });
                    ++n2;
                }
                return retVal;
            }

            @Override
            public boolean isDefaultSelected() {
                String value = element.getAttribute(SearchSubdestinationExtensionParser.DEFAULT_SELECTED_ATTR);
                return value == null ? true : new Boolean(value);
            }
        };
    }
}

