/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.DestinationCategoryNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ISubdestinationsActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchProvidersExtensionParser;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;

public class SearchProviderConfiguration
implements ISearchProviderConfiguration {
    private final ISearchProviderActivationConfig searchProviderActivationConfig;
    private final ISubdestinationsActivationConfig subdestinationsActivationConfig;
    private final ILogger logger = Logger.instance();

    public SearchProviderConfiguration(ISearchProviderActivationConfig searchProviderActivationConfig, ISubdestinationsActivationConfig subdestinationsActivationConfig) {
        this.searchProviderActivationConfig = searchProviderActivationConfig;
        this.subdestinationsActivationConfig = subdestinationsActivationConfig;
    }

    protected ISearchProvidersExtensionParser searchProvidersExtensionParser() {
        return this.searchProviderActivationConfig.getSearchProvidersExtensionParser();
    }

    @Override
    public Set<ISearchProviderDescription> getAvailableSearchProviderDescriptions(IObjectTypeDescription searchObjectType) {
        Set allProviders = this.searchProvidersExtensionParser().readContributions();
        HashSet<ISearchProviderDescription> result = new HashSet<ISearchProviderDescription>();
        for (ISearchProviderDescription provider : allProviders) {
            if (!provider.getObjectType().getId().equals(searchObjectType.getId())) continue;
            result.add(provider);
        }
        return result;
    }

    @Override
    public Set<IObjectTypeDescription> getObjectTypes() {
        return this.searchProviderActivationConfig.getObjectTypeExtensionParser().readContributions();
    }

    @Override
    public void activateSubdestination(IObjectTypeDescription searchObjectType, IDestinationCategoryDescription destinationCategory, ISearchProviderDescription searchProviderDescription, ISearchSubdestination subDestination, boolean activate) {
        this.subdestinationsActivationConfig.activateSubdestination(searchObjectType, destinationCategory, searchProviderDescription, subDestination, activate);
    }

    @Override
    public ISearchProviderDescription getActiveSearchProvider(IObjectTypeDescription objectType, IDestinationCategoryDescription destinationCategory) throws ProviderNotFoundException {
        return this.searchProviderActivationConfig.getActiveSearchProviderDescription(objectType, destinationCategory);
    }

    @Override
    public Set<IDestinationCategoryDescription> getAvailableDestinationCategoriesForObjectType(IObjectTypeDescription objectType) {
        HashSet<IDestinationCategoryDescription> result = new HashSet<IDestinationCategoryDescription>();
        for (IDestinationCategoryDescription category : this.getDestinationCategories()) {
            try {
                this.getActiveSearchProvider(objectType, category);
                result.add(category);
            }
            catch (ProviderNotFoundException providerNotFoundException) {}
        }
        return result;
    }

    @Override
    public Set<ISearchSubdestination> getAvailableSearchSubdestinations(IObjectTypeDescription objectType, IDestinationCategoryDescription destinationCategory, ISearchProviderDescription provider) {
        return this.subdestinationsActivationConfig.getAvailableSearchSubdestinations(objectType, destinationCategory, provider);
    }

    @Override
    public Set<IDestinationCategoryDescription> getDestinationCategories() {
        return this.searchProviderActivationConfig.getDestinationCategoryExtensionParser().readContributions();
    }

    @Override
    public Set<IDestinationsProviderDescription> getDestinationProvidersForCategory(IDestinationCategoryDescription category) {
        HashSet<IDestinationsProviderDescription> result = new HashSet<IDestinationsProviderDescription>();
        for (IDestinationsProviderDescription destProvider : this.getAvailableDestinationProviders()) {
            if (!category.getDestinationProviderIds().contains(destProvider.getId())) continue;
            result.add(destProvider);
        }
        return result;
    }

    @Override
    public Set<ISearchDestination> getSearchDestinations(IDestinationCategoryDescription category, IDestinationsProvider destinationsProvider) {
        HashSet<ISearchDestination> result = new HashSet<ISearchDestination>();
        Class<ISearchDestination> expectedDestinationClass = category.getDestinationsClass();
        for (ISearchDestination dest : destinationsProvider.getSearchDestinations()) {
            if (expectedDestinationClass.isAssignableFrom(dest.getClass())) {
                result.add(dest);
                continue;
            }
            this.logger.logWarn("Provider " + destinationsProvider.getClass().getName() + " did not provide destination of class " + category.getDestinationsClass().getName());
        }
        return result;
    }

    @Override
    public Set<IDestinationCategoryDescription> getDestinationCategoriesForDestination(ISearchDestination destination) throws DestinationCategoryNotFoundException {
        HashSet<IDestinationCategoryDescription> result = new HashSet<IDestinationCategoryDescription>();
        HashSet<String> destinationProvidersIds = new HashSet<String>();
        for (IDestinationsProviderDescription providerDescription : this.getAvailableDestinationProviders()) {
            if (!providerDescription.createProvider().getSearchDestinations().contains(destination)) continue;
            destinationProvidersIds.add(providerDescription.getId());
        }
        for (IDestinationCategoryDescription cat : this.searchProviderActivationConfig.getDestinationCategoryExtensionParser().readContributions()) {
            if (Collections.disjoint(destinationProvidersIds, cat.getDestinationProviderIds())) continue;
            result.add(cat);
        }
        if (result.isEmpty()) {
            throw new DestinationCategoryNotFoundException("Destination category for destination id " + destination.getDisplayName() + " was not found");
        }
        return result;
    }

    @Override
    public boolean isSubdestinationActive(ISearchSubdestination subdestination, IObjectTypeDescription objectType, IDestinationCategoryDescription destCategory, ISearchProviderDescription searchProvider) {
        return this.subdestinationsActivationConfig.isSubdestinationActive(subdestination, objectType, destCategory, searchProvider);
    }

    @Override
    public Set<IDestinationsProviderDescription> getAvailableDestinationProviders() {
        return this.searchProviderActivationConfig.getDestinationsProviderExtensionParser().readContributions();
    }
}

