/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.BindingHelper;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.BindingInfo;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.DataContext;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTVisualRenderer;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.widgets.Widget;

public class DataContextEditPart
extends AbstractGraphicalEditPart {
    private DataContext dataContext;

    public DataContextEditPart(DataContext dataContext) {
        this.setModel(dataContext);
        this.dataContext = dataContext;
    }

    protected List getModelSourceConnections() {
        XWTVisualRenderer controlRender = (XWTVisualRenderer)((Object)EditDomain.getEditDomain((EditPart)this).getViewerData(this.getViewer(), (Object)"org.eclipse.e4.tools.ui.designer.editor.VisualsRender"));
        Object root = controlRender.getRoot();
        if (root != null && root instanceof Widget) {
            root = XWTProxy.getModel((Widget)root);
            EditPart rootEp = (EditPart)this.getViewer().getEditPartRegistry().get(root);
            if (rootEp != null) {
                ArrayList<BindingInfo> sources = new ArrayList<BindingInfo>();
                List<BindingInfo> allBindings = BindingHelper.getBindings(rootEp);
                for (BindingInfo bindingInfo : allBindings) {
                    IObservable observeModel = bindingInfo.getModel();
                    if (!this.dataContext.equals(observeModel.getSource())) continue;
                    sources.add(bindingInfo);
                }
                return sources;
            }
        }
        return super.getModelSourceConnections();
    }

    protected IFigure createFigure() {
        Ellipse figure = new Ellipse();
        figure.setAntialias(1);
        figure.setForegroundColor(ColorConstants.blue);
        figure.setBackgroundColor(ColorConstants.yellow);
        figure.setLayoutManager((LayoutManager)new ToolbarLayout(true));
        Label label = new Label();
        if (this.dataContext != null && this.dataContext.getKey() != null) {
            label.setText(this.dataContext.getKey());
        }
        figure.setToolTip((IFigure)label);
        return figure;
    }

    protected void refreshVisuals() {
        GraphicalEditPart parent = (GraphicalEditPart)this.getParent();
        Rectangle bounds = parent.getFigure().getBounds().getCopy();
        Rectangle rect = new Rectangle();
        rect.setLocation(bounds.x + 1, bounds.y + 1);
        rect.setSize(16, 16);
        this.getFigure().setBounds(rect);
        super.refreshVisuals();
    }

    protected void createEditPolicies() {
    }
}

