/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.demo.cheatsheets.search.internal.search;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.demo.cheatsheets.search.destinations.AllCategoriesDest;
import org.eclipse.demo.cheatsheets.search.destinations.CSDestination;
import org.eclipse.demo.cheatsheets.search.internal.runtime.CSLoader;
import org.eclipse.demo.cheatsheets.search.internal.runtime.CheatSheetCategoryImpl;
import org.eclipse.demo.cheatsheets.search.internal.runtime.ICheatSheet;
import org.eclipse.demo.cheatsheets.search.internal.runtime.ICheatSheetCategory;
import org.eclipse.demo.cheatsheets.search.internal.runtime.ICheatSheetItem;
import org.eclipse.demo.cheatsheets.search.internal.runtime.RootCSItem;
import org.eclipse.demo.cheatsheets.search.internal.search.LocalCheatSheetSearchProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.api.SearchCancelledException;
import org.eclipse.platform.discovery.runtime.api.SearchFailedException;
import org.eclipse.platform.discovery.runtime.api.impl.SearchQuery;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;

class CheatSheetSearchQuery
extends SearchQuery {
    private ISearchParameters searchParams;

    CheatSheetSearchQuery(ISearchParameters searchParams) {
        this.searchParams = searchParams;
    }

    public Object execute(ILongOperationRunner lor) throws SearchFailedException, SearchCancelledException {
        try {
            return lor.run(this.queryOperation());
        }
        catch (LongOpCanceledException longOpCanceledException) {
            throw new IllegalStateException("Operation does not support cancellation");
        }
        catch (InvocationTargetException e) {
            throw new SearchFailedException(e.getCause());
        }
    }

    private ILongOperation<ICheatSheetCategory> queryOperation() {
        CheatSheetMatcher matcher = new CheatSheetMatcher(this.searchParams.getKeywordString());
        return new QueryOperation(matcher);
    }

    private class CheatSheetMatcher {
        private final String expression;

        public CheatSheetMatcher(String expression) {
            this.expression = expression;
        }

        public boolean matches(ICheatSheet sheet) {
            if (this.expression.equals("")) {
                return true;
            }
            return sheet.getName().toLowerCase().contains(this.expression);
        }
    }

    private class QueryOperation
    implements ILongOperation<ICheatSheetCategory> {
        private final CheatSheetMatcher mathcer;

        public QueryOperation(CheatSheetMatcher matcher) {
            this.mathcer = matcher;
        }

        public ICheatSheetCategory run(IProgressMonitor monitor) throws LongOpCanceledException, Exception {
            if (CheatSheetSearchQuery.this.searchParams.getGroupingHierarchy().equals((Object)LocalCheatSheetSearchProvider.FLAT_LIST)) {
                return this.flatListSheets();
            }
            return this.byCategoriesSheets();
        }

        private ICheatSheetCategory byCategoriesSheets() {
            RootCSItem result = new RootCSItem();
            for (ICheatSheetCategory cat : this.relevantCategories()) {
                Collection<ICheatSheetItem> children = this.getCategoryChildren(cat);
                if (children.size() <= 0) continue;
                CheatSheetCategoryImpl newCat = new CheatSheetCategoryImpl(cat.getCollectionElement(), null);
                newCat.getChildren().addAll(children);
                result.getChildren().add(newCat);
            }
            return result;
        }

        private Collection<ICheatSheetItem> getCategoryChildren(ICheatSheetCategory category) {
            ArrayList<ICheatSheetItem> result = new ArrayList<ICheatSheetItem>();
            for (ICheatSheetItem item : category.getChildren()) {
                CheatSheetCategoryImpl childCat;
                if (item instanceof ICheatSheetCategory && this.getCategoryChildren(childCat = new CheatSheetCategoryImpl(((ICheatSheetCategory)item).getCollectionElement(), category)).size() > 0) {
                    result.add(childCat);
                }
                if (!(item instanceof ICheatSheet) || !this.mathcer.matches((ICheatSheet)item)) continue;
                result.add((ICheatSheet)item);
            }
            return result;
        }

        private ICheatSheetCategory flatListSheets() {
            RootCSItem result = new RootCSItem();
            for (ICheatSheetCategory cat : this.relevantCategories()) {
                result.getChildren().addAll(this.extractCheatSheets(cat));
            }
            return result;
        }

        private Collection<ICheatSheet> extractCheatSheets(ICheatSheetCategory category) {
            ArrayList<ICheatSheet> result = new ArrayList<ICheatSheet>();
            for (ICheatSheetItem item : category.getChildren()) {
                if (item instanceof ICheatSheetCategory) {
                    result.addAll(this.extractCheatSheets((ICheatSheetCategory)item));
                }
                if (!(item instanceof ICheatSheet) || !this.mathcer.matches((ICheatSheet)item)) continue;
                result.add((ICheatSheet)item);
            }
            return result;
        }

        private Collection<ICheatSheetCategory> relevantCategories() {
            CSDestination destination = (CSDestination)CheatSheetSearchQuery.this.searchParams.getSearchDestination();
            ArrayList<ICheatSheetCategory> result = new ArrayList<ICheatSheetCategory>();
            for (ICheatSheetItem item : new CSLoader().loadCheatSheets().getChildren()) {
                assert (item instanceof ICheatSheetCategory);
                ICheatSheetCategory cat = (ICheatSheetCategory)item;
                if (!destination.getClass().equals(AllCategoriesDest.class) && !destination.getCategory().getID().equals(cat.getID())) continue;
                result.add(cat);
            }
            return result;
        }
    }
}

