/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class PText
extends PNode {
    public static final String PROPERTY_TEXT = "text";
    public static final int PROPERTY_CODE_TEXT = 524288;
    public static final String PROPERTY_FONT = "font";
    public static final int PROPERTY_CODE_FONT = 0x100000;
    public static Font DEFAULT_FONT = new Font((Device)Display.getCurrent(), "Helvetica", 12, 0);
    public static double DEFAULT_GREEK_THRESHOLD = 5.5;
    private String text;
    private Color textPaint;
    private Font font;
    protected double greekThreshold = DEFAULT_GREEK_THRESHOLD;
    private float justification = 0.0f;
    private boolean constrainHeightToTextHeight = true;
    private boolean constrainWidthToTextWidth = true;
    private transient String[] lines;
    private GC fontMetricsGc = null;

    public PText() {
        this.setTextPaint(this.createColor(2));
    }

    public PText(String aText) {
        this();
        this.setText(aText);
    }

    public float getJustification() {
        return this.justification;
    }

    public void setJustification(float just) {
        this.justification = just;
        this.recomputeLayout();
    }

    public Color getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Color textPaint) {
        this.textPaint = textPaint;
        this.invalidatePaint();
    }

    public boolean isConstrainWidthToTextWidth() {
        return this.constrainWidthToTextWidth;
    }

    public void setConstrainWidthToTextWidth(boolean constrainWidthToTextWidth) {
        this.constrainWidthToTextWidth = constrainWidthToTextWidth;
        this.recomputeLayout();
    }

    public boolean isConstrainHeightToTextHeight() {
        return this.constrainHeightToTextHeight;
    }

    public void setConstrainHeightToTextHeight(boolean constrainHeightToTextHeight) {
        this.constrainHeightToTextHeight = constrainHeightToTextHeight;
        this.recomputeLayout();
    }

    public double getGreekThreshold() {
        return this.greekThreshold;
    }

    public void setGreekThreshold(double threshold) {
        this.greekThreshold = threshold;
        this.invalidatePaint();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String aText) {
        String old = this.text;
        this.text = aText;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(524288, PROPERTY_TEXT, old, this.text);
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = DEFAULT_FONT;
        }
        return this.font;
    }

    public void setFont(Font aFont) {
        Font old = this.font;
        this.font = aFont;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(0x100000, PROPERTY_FONT, old, this.font);
    }

    public void recomputeLayout() {
        ArrayList<String> linesList = new ArrayList<String>();
        double textWidth = 0.0;
        double textHeight = 0.0;
        if (this.text != null && this.text.length() > 0) {
            if (this.fontMetricsGc == null) {
                this.fontMetricsGc = new GC((Drawable)Display.getCurrent());
            }
            this.fontMetricsGc.setFont(this.font);
            FontMetrics fontMetrics = this.fontMetricsGc.getFontMetrics();
            int spacing = this.fontMetricsGc.stringExtent((String)" ").x;
            float availableWidth = this.constrainWidthToTextWidth ? Float.MAX_VALUE : (float)this.getWidth();
            this.lines = this.text.split("\\s");
            StringBuilder line = new StringBuilder();
            int pos = 0;
            int width = 0;
            while (true) {
                Point extent;
                if (line.length() > 0) {
                    line.append(" ");
                    width += spacing;
                }
                Point point = extent = pos < this.lines.length ? this.fontMetricsGc.stringExtent(this.lines[pos]) : null;
                if (pos >= this.lines.length || (float)(width + extent.x) >= availableWidth && line.length() > 0) {
                    linesList.add(line.toString());
                    textWidth = Math.max(textWidth, (double)width);
                    textHeight += (double)fontMetrics.getHeight();
                    line.setLength(0);
                    width = 0;
                    if (pos >= this.lines.length) break;
                }
                line.append(this.lines[pos]);
                width += extent.x;
                ++pos;
            }
            this.lines = linesList.toArray(new String[linesList.size()]);
        }
        if (this.constrainWidthToTextWidth || this.constrainHeightToTextHeight) {
            double newWidth = this.getWidth();
            double newHeight = this.getHeight();
            if (this.constrainWidthToTextWidth) {
                newWidth = textWidth;
            }
            if (this.constrainHeightToTextHeight) {
                newHeight = textHeight;
            }
            super.setBounds(this.getX(), this.getY(), newWidth, newHeight);
        }
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        GC g2 = paintContext.getGraphics();
        FontMetrics fontMetrics = g2.getFontMetrics();
        float screenFontSize = (float)fontMetrics.getHeight() * (float)paintContext.getScale();
        if (this.textPaint != null && (double)screenFontSize > this.greekThreshold) {
            float x = (float)this.getX();
            float y = (float)this.getY();
            float bottomY = (float)this.getHeight() + y;
            if (this.lines == null) {
                this.recomputeLayout();
                this.repaint();
                return;
            }
            g2.setForeground(this.textPaint);
            int i = 0;
            while (i < this.lines.length) {
                String tl = this.lines[i];
                if (bottomY < y) {
                    return;
                }
                float offset = (float)(this.getWidth() - (double)g2.stringExtent((String)tl).x) * this.justification;
                g2.drawString(tl, (int)(x + offset), (int)y);
                y += (float)fontMetrics.getHeight();
                ++i;
            }
        }
    }

    protected void internalUpdateBounds(double x, double y, double width, double height) {
        this.recomputeLayout();
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("text=" + (this.text == null ? "null" : this.text));
        result.append(",font=" + (this.font == null ? "null" : this.font.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

