/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.platform.discovery.util.internal.ContractChecker;

public class CharsetUtils {
    public static final String US_ASCII = "US-ASCII";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String UTF_16 = "UTF-16";
    private static final String[] STANDARD_CHARSETS = new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"};

    public static final String[] getStandardCharsets() {
        return Arrays.copyOf(STANDARD_CHARSETS, STANDARD_CHARSETS.length);
    }

    public static Charset getUS_ASCII() {
        return Charset.forName(US_ASCII);
    }

    public static Charset getISO_8859_1() {
        return Charset.forName(ISO_8859_1);
    }

    public static Charset getUTF_8() {
        return Charset.forName(UTF_8);
    }

    public static Charset getUTF_16BE() {
        return Charset.forName(UTF_16BE);
    }

    public static Charset getUTF_16LE() {
        return Charset.forName(UTF_16LE);
    }

    public static Charset getUTF_16() {
        return Charset.forName(UTF_16);
    }

    public static boolean isStandardCharset(String charset) {
        ContractChecker.emptyStringCheckParam(charset, "charset");
        String[] stringArray = STANDARD_CHARSETS;
        int n = STANDARD_CHARSETS.length;
        int n2 = 0;
        while (n2 < n) {
            String aStandardCharset = stringArray[n2];
            if (aStandardCharset.equalsIgnoreCase(charset)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

