/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Optional;

public class InvokeInRATTest
extends TestCase {
    public void testStaticInvoke() {
        IEclipseContext context = EclipseContextFactory.create();
        final int[] count = new int[1];
        context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                TestHandler handler = (TestHandler)context.get("handlerA");
                if (handler != null) {
                    ContextInjectionFactory.invoke((Object)handler, CanExecute.class, (IEclipseContext)context);
                    count[0] = count[0] + 1;
                }
                return true;
            }
        });
        context.set("active", (Object)new Integer(123));
        context.set("selected", (Object)"abc");
        TestHandler handler = new TestHandler();
        context.set("handlerA", (Object)handler);
        InvokeInRATTest.assertEquals((Object)new Integer(123), (Object)handler.active);
        InvokeInRATTest.assertEquals((Object)"abc", (Object)handler.selected);
        count[0] = 0;
        TestHandler newHandler = new TestHandler();
        context.set("handlerA", (Object)newHandler);
        InvokeInRATTest.assertEquals((int)1, (int)count[0]);
        InvokeInRATTest.assertEquals((Object)new Integer(123), (Object)newHandler.active);
        InvokeInRATTest.assertEquals((Object)"abc", (Object)newHandler.selected);
        context.set("active", (Object)new Integer(456));
        context.set("selected", (Object)"xyz");
        InvokeInRATTest.assertEquals((Object)new Integer(123), (Object)handler.active);
        InvokeInRATTest.assertEquals((Object)"abc", (Object)handler.selected);
        InvokeInRATTest.assertEquals((Object)new Integer(123), (Object)newHandler.active);
        InvokeInRATTest.assertEquals((Object)"abc", (Object)newHandler.selected);
    }

    static class TestHandler {
        public Object active;
        public Object selected;

        TestHandler() {
        }

        @CanExecute
        public void testEnablement(@Optional @Named(value="active") Object active, @Optional @Named(value="selected") Object selected) {
            this.active = active;
            this.selected = selected;
        }
    }
}

