/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractGalleryItemRenderer {
    public static final String OVERLAY_BOTTOM_RIGHT = "org.eclipse.nebula.widget.gallery.bottomRightOverlay";
    public static final String OVERLAY_BOTTOM_LEFT = "org.eclipse.nebula.widget.gallery.bottomLeftOverlay";
    public static final String OVERLAY_TOP_RIGHT = "org.eclipse.nebula.widget.gallery.topRightOverlay";
    public static final String OVERLAY_TOP_LEFT = "org.eclipse.nebula.widget.gallery.topLeftOverlay";
    protected static final String EMPTY_STRING = "";
    protected Gallery gallery;
    protected boolean selected;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public abstract void draw(GC var1, GalleryItem var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void dispose();

    public void preDraw(GC gc) {
    }

    public Gallery getGallery() {
        return this.gallery;
    }

    public void setGallery(Gallery gallery) {
        this.gallery = gallery;
    }

    protected double getOverlayRatio(Point imageSize, Point overlaySizeTopLeft, Point overlaySizeTopRight, Point overlaySizeBottomLeft, Point overlaySizeBottomRight) {
        double ratio = 1.0;
        if (overlaySizeTopLeft.x + overlaySizeTopRight.x > imageSize.x) {
            ratio = Math.min(ratio, (double)imageSize.x / (double)(overlaySizeTopLeft.x + overlaySizeTopRight.x));
        }
        if (overlaySizeBottomLeft.x + overlaySizeBottomRight.x > imageSize.x) {
            ratio = Math.min(ratio, (double)imageSize.x / (double)(overlaySizeBottomLeft.x + overlaySizeBottomRight.x));
        }
        if (overlaySizeTopLeft.y + overlaySizeBottomLeft.y > imageSize.y) {
            ratio = Math.min(ratio, (double)imageSize.y / (double)(overlaySizeTopLeft.y + overlaySizeBottomLeft.y));
        }
        if (overlaySizeTopRight.y + overlaySizeBottomRight.y > imageSize.y) {
            ratio = Math.min(ratio, (double)imageSize.y / (double)(overlaySizeTopRight.y + overlaySizeBottomRight.y));
        }
        return ratio;
    }

    protected void drawAllOverlays(GC gc, GalleryItem item, int x, int y, Point imageSize, int xShift, int yShift) {
        Image[] imagesBottomLeft = this.getImageOverlay(item, OVERLAY_BOTTOM_LEFT);
        Image[] imagesBottomRight = this.getImageOverlay(item, OVERLAY_BOTTOM_RIGHT);
        Image[] imagesTopLeft = this.getImageOverlay(item, OVERLAY_TOP_LEFT);
        Image[] imagesTopRight = this.getImageOverlay(item, OVERLAY_TOP_RIGHT);
        Point overlaySizeBottomLeft = this.getOverlaySize(imagesBottomLeft);
        Point overlaySizeBottomRight = this.getOverlaySize(imagesBottomRight);
        Point overlaySizeTopLeft = this.getOverlaySize(imagesTopLeft);
        Point overlaySizeTopRight = this.getOverlaySize(imagesTopRight);
        double ratio = this.getOverlayRatio(imageSize, overlaySizeTopLeft, overlaySizeTopRight, overlaySizeBottomLeft, overlaySizeBottomRight);
        this.drawOverlayImages(gc, x + xShift, y + yShift, ratio, imagesTopLeft);
        this.drawOverlayImages(gc, (int)((double)(x + xShift + imageSize.x) - (double)overlaySizeBottomRight.x * ratio), y + yShift, ratio, imagesTopRight);
        this.drawOverlayImages(gc, x + xShift, (int)((double)(y + yShift + imageSize.y) - (double)overlaySizeBottomRight.y * ratio), ratio, imagesBottomLeft);
        this.drawOverlayImages(gc, (int)((double)(x + xShift + imageSize.x) - (double)overlaySizeBottomRight.x * ratio), (int)((double)(y + yShift + imageSize.y) - (double)overlaySizeBottomRight.y * ratio), ratio, imagesBottomRight);
    }

    protected void drawOverlayImages(GC gc, int x, int y, double ratio, Image[] images) {
        if (images == null) {
            return;
        }
        int position = 0;
        int i = 0;
        while (i < images.length) {
            Image img = images[i];
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x + position, y, (int)((double)img.getBounds().width * ratio), (int)((double)img.getBounds().height * ratio));
            position = (int)((double)position + (double)img.getBounds().width * ratio);
            ++i;
        }
    }

    protected Point getOverlaySize(Image[] images) {
        if (images == null) {
            return new Point(0, 0);
        }
        Point result = new Point(0, 0);
        int i = 0;
        while (i < images.length) {
            result.x += images[i].getBounds().width;
            result.y = Math.max(result.y, images[i].getBounds().height);
            ++i;
        }
        return result;
    }

    protected Image[] getImageOverlay(GalleryItem item, String id) {
        Object data = item.getData(id);
        if (data == null) {
            return null;
        }
        Image[] result = null;
        if (data instanceof Image) {
            result = new Image[]{(Image)data};
        }
        if (data instanceof Image[]) {
            result = (Image[])data;
        }
        return result;
    }
}

