/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.resources.semantic.examples.SemanticResourcesPluginExamples;
import org.eclipse.core.resources.semantic.examples.webdav.WebDAVUtil;
import org.eclipse.core.resources.semantic.examples.wizard.AddWebDAVResourceNameAndURLPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddWebDAVResourceCheckURLPage
extends WizardPage {
    Text urlText;
    Button asFolder;
    Button asFile;
    Button ignoreCheckResults;
    Button retrieveContent;
    String url;

    public AddWebDAVResourceCheckURLPage() {
        super(AddWebDAVResourceNameAndURLPage.class.getName());
        this.setTitle(Messages.AddWebDAVResourceCheckURLPage_PageTitle_XGRP);
    }

    public boolean isFolder() {
        return this.asFolder.getSelection();
    }

    public boolean shouldRetrieveContent() {
        return this.retrieveContent.getSelection();
    }

    public void setUrl(String newUrl) {
        this.setPageComplete(false);
        this.url = newUrl;
        if (this.urlText != null) {
            if (this.url == null) {
                this.urlText.setText("");
            } else {
                this.urlText.setText(this.url);
            }
        }
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        new Label(main, 0).setText(Messages.AddWebDAVResourceCheckURLPage_URLLabel_XFLD);
        this.urlText = new Text(main, 2048);
        this.urlText.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.urlText);
        if (this.url != null) {
            this.urlText.setText(this.url);
        }
        this.asFolder = new Button(main, 16);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.asFolder);
        this.asFolder.setText(Messages.AddWebDAVResourceCheckURLPage_FolderLabel_XFLD);
        this.asFolder.setEnabled(false);
        this.asFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddWebDAVResourceCheckURLPage.this.checkPage();
            }
        });
        this.asFile = new Button(main, 16);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.asFile);
        this.asFile.setText(Messages.AddWebDAVResourceCheckURLPage_FileLabel_XFLD);
        this.asFile.setEnabled(false);
        this.asFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddWebDAVResourceCheckURLPage.this.checkPage();
            }
        });
        this.ignoreCheckResults = new Button(main, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.ignoreCheckResults);
        this.ignoreCheckResults.setText(Messages.AddWebDAVResourceCheckURLPage_IgnoreButton_XFLD);
        this.ignoreCheckResults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddWebDAVResourceCheckURLPage.this.asFolder.setEnabled(AddWebDAVResourceCheckURLPage.this.ignoreCheckResults.getSelection());
                AddWebDAVResourceCheckURLPage.this.asFile.setEnabled(AddWebDAVResourceCheckURLPage.this.ignoreCheckResults.getSelection());
                AddWebDAVResourceCheckURLPage.this.checkPage();
            }
        });
        this.retrieveContent = new Button(main, 32);
        this.retrieveContent.setSelection(true);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.retrieveContent);
        this.retrieveContent.setText(Messages.AddWebDAVResourceCheckURLPage_RetrieveContentAfterFinish_XFLD);
        this.setPageComplete(false);
        this.setControl((Control)main);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.checkPage();
        }
    }

    /*
     * Unable to fully structure code
     */
    void checkPage() {
        block19: {
            block18: {
                this.setErrorMessage(null);
                this.setMessage(null, 2);
                try {
                    if (this.url != null) break block18;
                    this.setErrorMessage(Messages.AddWebDAVResourceCheckURLPage_NoURLMessage_XMSG);
                }
                catch (Throwable var5_11) {
                    v0 = errorFound = this.getErrorMessage() != null;
                    if (!errorFound && this.ignoreCheckResults.getSelection()) {
                        this.setMessage(Messages.AddWebDAVResourceCheckURLPage_ChecksIgnoreMessage_XMSG, 2);
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    throw var5_11;
                }
                v1 = errorFound = this.getErrorMessage() != null;
                if (!errorFound && this.ignoreCheckResults.getSelection()) {
                    this.setMessage(Messages.AddWebDAVResourceCheckURLPage_ChecksIgnoreMessage_XMSG, 2);
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            try {
                uri = new URI(this.url);
            }
            catch (URISyntaxException v2) {
                this.setErrorMessage(NLS.bind((String)Messages.AddWebDAVResourceCheckURLPage_InvalidUrlMessage_XMSG, (Object)this.url));
                v3 = errorFound = this.getErrorMessage() != null;
                if (!errorFound && this.ignoreCheckResults.getSelection()) {
                    this.setMessage(Messages.AddWebDAVResourceCheckURLPage_ChecksIgnoreMessage_XMSG, 2);
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            if (this.ignoreCheckResults.getSelection()) ** GOTO lbl56
            this.asFolder.setSelection(false);
            this.asFile.setSelection(false);
            isFolder = new boolean[]{true};
            exception = new Exception[1];
            try {
                this.getWizard().getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            isFolder[0] = WebDAVUtil.checkWebDAVURL((URI)uri, (IProgressMonitor)monitor);
                        }
                        catch (Exception e) {
                            exception[0] = e;
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                SemanticResourcesPluginExamples.handleError(e.getMessage(), e, true);
            }
            catch (InterruptedException e) {
                SemanticResourcesPluginExamples.handleError(e.getMessage(), e, true);
            }
            if (exception[0] == null) break block19;
            this.setErrorMessage(NLS.bind((String)Messages.AddWebDAVResourceCheckURLPage_InvalidURLWithCause_XMSG, (Object)this.url, (Object)exception[0].getMessage()));
            v4 = errorFound = this.getErrorMessage() != null;
            if (!errorFound && this.ignoreCheckResults.getSelection()) {
                this.setMessage(Messages.AddWebDAVResourceCheckURLPage_ChecksIgnoreMessage_XMSG, 2);
            }
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (isFolder[0]) {
            this.asFolder.setSelection(true);
        } else {
            this.asFile.setSelection(true);
        }
lbl56:
        // 3 sources

        if (!this.asFile.getSelection() && !this.asFolder.getSelection()) {
            this.setErrorMessage(Messages.AddWebDAVResourceCheckURLPage_MustBeFileOrFolderMessage_XMSG);
        }
        v5 = errorFound = this.getErrorMessage() != null;
        if (!errorFound && this.ignoreCheckResults.getSelection()) {
            this.setMessage(Messages.AddWebDAVResourceCheckURLPage_ChecksIgnoreMessage_XMSG, 2);
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

