/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.parts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.xwt.tools.ui.designer.core.figures.ContentPaneFigure;
import org.eclipse.e4.xwt.tools.ui.designer.core.figures.ImageFigure;
import org.eclipse.e4.xwt.tools.ui.designer.core.figures.OutlineBorder;
import org.eclipse.e4.xwt.tools.ui.designer.core.images.IImageListener;
import org.eclipse.e4.xwt.tools.ui.designer.core.images.ImageFigureController;
import org.eclipse.e4.xwt.tools.ui.designer.core.parts.AbstractDiagramEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.core.parts.RefreshContext;
import org.eclipse.e4.xwt.tools.ui.designer.core.policies.DefaultComponentEditPolicy;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.JavaModelUtil;
import org.eclipse.e4.xwt.tools.ui.designer.core.visuals.IVisualInfo;
import org.eclipse.e4.xwt.tools.ui.designer.core.visuals.swt.WidgetInfo;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionFilter;

public abstract class VisualEditPart
extends AbstractGraphicalEditPart
implements IActionFilter {
    private boolean useBorder = false;
    private boolean transparent;
    private ImageFigureController imageFigureController;
    private IImageListener imageListener;
    private IVisualInfo visualInfo;

    public VisualEditPart(EObject model) {
        this.setModel(model);
    }

    public boolean testAttribute(Object target, String name, String value) {
        Object model;
        if ("ModelType".equals(name) && (model = this.getModel()) != null) {
            Class<?> type = model.getClass();
            return JavaModelUtil.isKindOf(type, value);
        }
        return false;
    }

    protected IFigure createFigure() {
        ContentPaneFigure figure = new ContentPaneFigure();
        Object contentPane = null;
        if (!this.isRoot()) {
            contentPane = this.createContentPane();
        } else {
            ImageFigure imageFigure = new ImageFigure();
            if (this.isUseBorder()) {
                imageFigure.setBorder((Border)new OutlineBorder(150, ColorConstants.lightGray, null, 1));
            }
            imageFigure.setOpaque(!this.isTransparent());
            if (!this.isTransparent()) {
                this.imageFigureController = new ImageFigureController();
                this.imageFigureController.setImageFigure(imageFigure);
            }
            contentPane = imageFigure;
        }
        contentPane.setLayoutManager((LayoutManager)new XYLayout());
        figure.setContentPane((IFigure)contentPane);
        return figure;
    }

    protected IFigure createContentPane() {
        return new Label();
    }

    public IFigure getContentPane() {
        return this.getContentPaneFigure().getContentPane();
    }

    protected ContentPaneFigure getContentPaneFigure() {
        return (ContentPaneFigure)this.getFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DefaultComponentEditPolicy());
    }

    public void activate() {
        if (!this.isTransparent() && this.imageFigureController != null) {
            this.imageFigureController.setImageNotifier(this.getVisualInfo());
        }
        if (this.imageListener == null) {
            this.imageListener = new IImageListener(){

                public void imageChanged(Image image) {
                    VisualEditPart.this.refreshVisuals();
                    for (EditPart child : VisualEditPart.this.getChildren()) {
                        if (!(child instanceof VisualEditPart)) continue;
                        ((VisualEditPart)child).refreshVisuals();
                    }
                }
            };
        }
        this.getVisualInfo().addImageListener(this.imageListener);
        super.activate();
    }

    public void refresh() {
    }

    protected boolean isVisualInfoObsolate() {
        return false;
    }

    public final void refresh(RefreshContext context) {
        if (this.isVisualInfoObsolate()) {
            this.visualInfo = null;
        }
        if (context == null) {
            return;
        }
        if (!this.validateVisuals()) {
            return;
        }
        if (context.refreshChildren()) {
            this.refreshChildren();
        }
        if (context.refreshImage()) {
            this.getUIDisplay().asyncExec(new Runnable(){

                public void run() {
                    VisualEditPart.this.refreshImage();
                }
            });
            context.setImageRefreshed();
        }
        if (context.refreshVisuals()) {
            this.refreshVisuals();
        }
        this.refresh();
    }

    protected boolean validateVisuals() {
        return this.getVisualInfo() != null && this.getVisualInfo().getVisualObject() != null;
    }

    protected final void refreshImage() {
        VisualEditPart root = this.getRootVisualEditPart();
        if (root.validateVisuals()) {
            root.getVisualInfo().refreshImage();
        }
    }

    protected final void refreshVisuals() {
        if (!this.validateVisuals()) {
            return;
        }
        IFigure figure = this.getFigure();
        if (figure != null && figure.getParent() != null) {
            Rectangle r = new Rectangle(this.getBounds());
            figure.setBounds(r);
            this.setLayoutConstraint((EditPart)this, figure, r);
        }
    }

    protected final void refreshChildren() {
        super.refreshChildren();
    }

    protected Display getUIDisplay() {
        IVisualInfo visualInfo = this.getVisualInfo();
        if (visualInfo instanceof WidgetInfo) {
            return ((WidgetInfo)visualInfo).getDisplay();
        }
        return Display.getCurrent();
    }

    protected VisualEditPart getRootVisualEditPart() {
        VisualEditPart root = this;
        while (!(root.getParent() instanceof AbstractDiagramEditPart)) {
            if (root.getParent() == null) break;
            root = root.getParent();
        }
        return root;
    }

    protected Rectangle getBounds() {
        return this.getVisualInfo().getBounds();
    }

    public IVisualInfo getVisualInfo() {
        if (this.visualInfo == null) {
            this.visualInfo = this.createVisualInfo();
        }
        return this.visualInfo;
    }

    protected abstract IVisualInfo createVisualInfo();

    public void deactivate() {
        super.deactivate();
        if (this.imageFigureController != null) {
            this.imageFigureController.deactivate();
        }
        IVisualInfo visualInfo = this.getVisualInfo();
        if (this.imageListener != null && visualInfo != null) {
            visualInfo.removeImageListener(this.imageListener);
        }
    }

    public void setUseBorder(boolean useBorder) {
        this.useBorder = useBorder;
    }

    public boolean isUseBorder() {
        return this.useBorder;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isRoot() {
        return this.getParent() instanceof AbstractDiagramEditPart;
    }

    public EObject getCastModel() {
        return (EObject)super.getModel();
    }

    public String toString() {
        IVisualInfo visualInfo = this.getVisualInfo();
        if (visualInfo != null && visualInfo.getVisualObject() != null) {
            return "EditPart(" + visualInfo.getVisualObject().getClass().getSimpleName() + ")";
        }
        return "";
    }
}

