/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.ToolBarManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarContributionRecord {
    MToolBar toolbarModel;
    MToolBarContribution toolbarContribution;
    ArrayList<MToolBarElement> generatedElements = new ArrayList();
    HashSet<MToolBarElement> sharedElements = new HashSet();
    ToolBarManagerRenderer renderer;
    boolean isVisible = true;

    public ToolBarContributionRecord(MToolBar model, MToolBarContribution contribution, ToolBarManagerRenderer renderer) {
        this.toolbarModel = model;
        this.toolbarContribution = contribution;
        this.renderer = renderer;
    }

    public ToolBarManager getManagerForModel() {
        return this.renderer.getManager(this.toolbarModel);
    }

    public void updateVisibility(IEclipseContext context) {
        boolean currentVisibility;
        ExpressionContext exprContext = new ExpressionContext(context);
        this.updateIsVisible(exprContext);
        HashSet<ToolBarContributionRecord> recentlyUpdated = new HashSet<ToolBarContributionRecord>();
        recentlyUpdated.add(this);
        for (MToolBarElement item : this.generatedElements) {
            currentVisibility = this.computeVisibility(recentlyUpdated, item, exprContext);
            item.setVisible(currentVisibility);
        }
        for (MToolBarElement item : this.sharedElements) {
            currentVisibility = this.computeVisibility(recentlyUpdated, item, exprContext);
            item.setVisible(currentVisibility);
        }
        this.getManagerForModel().markDirty();
    }

    public void updateIsVisible(ExpressionContext exprContext) {
        this.isVisible = ContributionsAnalyzer.isVisible((MToolBarContribution)this.toolbarContribution, (ExpressionContext)exprContext);
    }

    public boolean computeVisibility(HashSet<ToolBarContributionRecord> recentlyUpdated, MToolBarElement item, ExpressionContext exprContext) {
        ArrayList<ToolBarContributionRecord> list;
        boolean currentVisibility = this.isVisible;
        if (item instanceof MToolBarSeparator && (list = this.renderer.getList(item)) != null) {
            Iterator<ToolBarContributionRecord> cr = list.iterator();
            while (!currentVisibility && cr.hasNext()) {
                ToolBarContributionRecord rec = cr.next();
                if (!recentlyUpdated.contains(rec)) {
                    rec.updateIsVisible(exprContext);
                    recentlyUpdated.add(rec);
                }
                currentVisibility |= rec.isVisible;
            }
        }
        if (currentVisibility && item.getVisibleWhen() instanceof MCoreExpression) {
            boolean val;
            currentVisibility = val = ContributionsAnalyzer.isVisible((MCoreExpression)((MCoreExpression)item.getVisibleWhen()), (ExpressionContext)exprContext);
        }
        return currentVisibility;
    }

    public boolean anyVisibleWhen() {
        if (this.toolbarContribution.getVisibleWhen() != null) {
            return true;
        }
        for (MToolBarElement child : this.toolbarContribution.getChildren()) {
            if (child.getVisibleWhen() == null) continue;
            return true;
        }
        return false;
    }

    public boolean mergeIntoModel() {
        int idx = ToolBarContributionRecord.getIndex(this.toolbarModel, this.toolbarContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        for (MToolBarElement item : this.toolbarContribution.getChildren()) {
            MToolBarElement copy = (MToolBarElement)EcoreUtil.copy((EObject)((EObject)item));
            if (copy instanceof MToolBarSeparator) {
                MToolBarSeparator shared = this.findExistingSeparator(copy.getElementId());
                if (shared == null) {
                    shared = (MToolBarSeparator)copy;
                    this.renderer.linkElementToContributionRecord(copy, this);
                    this.toolbarModel.getChildren().add(idx++, copy);
                } else {
                    copy = shared;
                }
                this.sharedElements.add((MToolBarElement)shared);
            } else {
                this.generatedElements.add(copy);
                this.renderer.linkElementToContributionRecord(copy, this);
                this.toolbarModel.getChildren().add(idx++, copy);
            }
            if (!(copy instanceof MToolBarSeparator)) continue;
            ArrayList<ToolBarContributionRecord> array = this.renderer.getList(copy);
            array.add(this);
        }
        return true;
    }

    MToolBarSeparator findExistingSeparator(String id) {
        if (id == null) {
            return null;
        }
        for (MToolBarElement item : this.toolbarModel.getChildren()) {
            if (!(item instanceof MToolBarSeparator) || !id.equals(item.getElementId())) continue;
            return (MToolBarSeparator)item;
        }
        return null;
    }

    public void dispose() {
        for (MToolBarElement copy : this.generatedElements) {
            this.toolbarModel.getChildren().remove(copy);
        }
        for (MToolBarElement shared : this.sharedElements) {
            ArrayList<ToolBarContributionRecord> array = this.renderer.getList(shared);
            array.remove(this);
            if (!array.isEmpty()) continue;
            this.toolbarModel.getChildren().remove(shared);
        }
    }

    private static int getIndex(MElementContainer<?> model, String positionInParent) {
        String id = null;
        String modifier = null;
        if (positionInParent != null && positionInParent.length() > 0) {
            String[] array = positionInParent.split("=");
            modifier = array[0];
            id = array[1];
        }
        if (id == null) {
            return model.getChildren().size();
        }
        int idx = 0;
        int size = model.getChildren().size();
        while (idx < size) {
            if (id.equals(((MUIElement)model.getChildren().get(idx)).getElementId())) {
                if ("after".equals(modifier)) {
                    ++idx;
                }
                return idx;
            }
            ++idx;
        }
        return id.equals("additions") ? model.getChildren().size() : -1;
    }
}

