/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.internal.favorites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoLoadProvider;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoStoreProvider;
import org.eclipse.platform.discovery.runtime.api.persistence.MementoLoadProviderException;
import org.eclipse.platform.discovery.runtime.api.persistence.MementoStoreProviderException;
import org.eclipse.platform.discovery.runtime.internal.persistence.IMementoContentManager;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.runtime.internal.persistence.util.IPersistenceProviderRegistry;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.ContractChecker;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;
import org.eclipse.ui.IMemento;

public class SearchFavoritesContentManager
implements IMementoContentManager<DestinationItemPair> {
    private final IPersistenceProviderRegistry providerRegistry;
    private final Collection<IMementoLoadProvider> loadProviderCollection;
    private final Collection<IMementoStoreProvider> storeProviderCollection;
    private final ILogger logger;

    public SearchFavoritesContentManager(IPersistenceProviderRegistry providerRegistry) throws MementoContentManagerException {
        this.providerRegistry = providerRegistry;
        this.loadProviderCollection = this.providerRegistry.collectAllLoadProviders();
        this.storeProviderCollection = this.providerRegistry.collectAllStoreProviders();
        this.logger = Logger.instance();
    }

    public Collection<DestinationItemPair> loadContent(IMemento container, ILongOperationRunner opRunner) throws MementoContentManagerException {
        if (container == null) {
            throw new NullPointerException();
        }
        ArrayList<DestinationItemPair> content = new ArrayList<DestinationItemPair>();
        HashSet<IMemento> mementoRegistry = new HashSet<IMemento>();
        Collection<IMemento> mementoCollection = null;
        ArrayList<IMementoLoadProvider> brokenLoadProviderCollection = new ArrayList<IMementoLoadProvider>();
        for (IMementoLoadProvider loadProvider : this.loadProviderCollection) {
            mementoCollection = this.selectContentForLoadProvider(container, loadProvider);
            this.verifyValidContentForLoadProvider(mementoRegistry, mementoCollection);
            mementoRegistry.addAll(mementoCollection);
            try {
                this.createContentForLocalProvider(content, loadProvider, mementoCollection, opRunner);
            }
            catch (MementoLoadProviderException mementoLoadProviderException) {
                brokenLoadProviderCollection.add(loadProvider);
            }
        }
        if (!brokenLoadProviderCollection.isEmpty()) {
            this.handleLoadStrategyBrokenContracts(brokenLoadProviderCollection);
        }
        return content;
    }

    private Collection<IMemento> selectContentForLoadProvider(IMemento container, IMementoLoadProvider loadProvider) {
        IMemento[] mementos;
        ArrayList<IMemento> providerMementos = new ArrayList<IMemento>();
        IMemento[] iMementoArray = mementos = container.getChildren(loadProvider.getChildType());
        int n = mementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            if (loadProvider.canLoad(memento)) {
                providerMementos.add(memento);
            }
            ++n2;
        }
        return providerMementos;
    }

    private boolean verifyValidContentForLoadProvider(Collection<IMemento> mementoRegistry, Collection<IMemento> mementoCollection) throws MementoContentManagerException {
        boolean validContent;
        ArrayList<IMemento> collisionMementoCollection = new ArrayList<IMemento>(mementoCollection);
        collisionMementoCollection.retainAll(mementoRegistry);
        if (collisionMementoCollection.size() != 0) {
            return false;
        }
        ArrayList<IMementoLoadProvider> collisionProviderCollection = new ArrayList<IMementoLoadProvider>();
        for (IMemento memento : mementoCollection) {
            for (IMementoLoadProvider loadProvider : this.loadProviderCollection) {
                if (!loadProvider.canLoad(memento) || collisionProviderCollection.contains(loadProvider)) continue;
                collisionProviderCollection.add(loadProvider);
            }
        }
        assert (collisionProviderCollection.size() <= 1) : "At most one load provider is permited.";
        boolean bl = validContent = collisionProviderCollection.size() <= 1;
        if (!validContent) {
            this.handleLoadStrategyCollisions(collisionProviderCollection, collisionMementoCollection);
        }
        return validContent;
    }

    private void handleLoadStrategyCollisions(Collection<IMementoLoadProvider> collisionProviderCollection, Collection<IMemento> collisionMementoCollection) throws MementoContentManagerException {
        StringBuilder collisionMessage = new StringBuilder();
        collisionMessage.append("Unexpected collisions loading items.");
        collisionMessage.append("\nLoad providers causing collisions : ");
        for (IMementoLoadProvider loadProvider : collisionProviderCollection) {
            collisionMessage.append("\n" + loadProvider.getDescriptor());
        }
        collisionMessage.append("\nMementos part of the collisions : ");
        for (IMemento memento : collisionMementoCollection) {
            collisionMessage.append("\nMemento ID : " + memento.getID());
            collisionMessage.append(", Memento Type : " + memento.getType());
        }
        this.logger.logError(collisionMessage.toString());
        throw new MementoContentManagerException(collisionMessage.toString());
    }

    private void handleLoadStrategyBrokenContracts(Collection<IMementoLoadProvider> brokenLoadProviderCollection) throws MementoContentManagerException {
        StringBuilder brokenContractMessage = new StringBuilder();
        brokenContractMessage.append("Broken load providers: ");
        for (IMementoLoadProvider loadProvider : brokenLoadProviderCollection) {
            brokenContractMessage.append("\n" + loadProvider.getDescriptor());
        }
        this.logger.logError(brokenContractMessage.toString());
        this.loadProviderCollection.removeAll(brokenLoadProviderCollection);
    }

    private void createContentForLocalProvider(Collection<DestinationItemPair> content, IMementoLoadProvider loadProvider, Collection<IMemento> mementoCollection, ILongOperationRunner opRunner) throws MementoLoadProviderException {
        for (IMemento memento : mementoCollection) {
            content.add(loadProvider.load(memento, opRunner));
        }
    }

    public void saveContent(IMemento container, Collection<DestinationItemPair> collection, ILongOperationRunner opRunner) throws MementoContentManagerException {
        ContractChecker.nullCheckParam((Object)container, (String)"container");
        ContractChecker.nullCheckParam(collection, (String)"collection");
        ArrayList<IMementoStoreProvider> brokenStoreProviderCollection = new ArrayList<IMementoStoreProvider>();
        IMementoStoreProvider storeProvider = null;
        for (DestinationItemPair pair : collection) {
            storeProvider = this.selectStoreProviderForPair(pair);
            if (storeProvider == null || pair == null) continue;
            try {
                storeProvider.store(container, pair, opRunner);
            }
            catch (MementoStoreProviderException mementoStoreProviderException) {
                brokenStoreProviderCollection.add(storeProvider);
            }
        }
        if (!brokenStoreProviderCollection.isEmpty()) {
            this.handleStoreStrategyBrokenContracts(brokenStoreProviderCollection);
        }
    }

    private IMementoStoreProvider selectStoreProviderForPair(DestinationItemPair pair) throws MementoContentManagerException {
        IMementoStoreProvider storeProvider2;
        ArrayList<IMementoStoreProvider> collisionProviderCollection = new ArrayList<IMementoStoreProvider>();
        for (IMementoStoreProvider storeProvider2 : this.storeProviderCollection) {
            if (!storeProvider2.canStore(pair)) continue;
            collisionProviderCollection.add(storeProvider2);
        }
        this.verifyValidStoreProvidersForPair(collisionProviderCollection, pair);
        storeProvider2 = null;
        if (collisionProviderCollection.iterator().hasNext()) {
            storeProvider2 = (IMementoStoreProvider)collisionProviderCollection.iterator().next();
        }
        return storeProvider2;
    }

    private void verifyValidStoreProvidersForPair(Collection<IMementoStoreProvider> collisionProviderCollection, DestinationItemPair pair) throws MementoContentManagerException {
        if (collisionProviderCollection.size() > 1) {
            this.handleStoreStrategyCollisions(collisionProviderCollection, pair);
        }
    }

    private void handleStoreStrategyCollisions(Collection<IMementoStoreProvider> collisionProviderCollection, DestinationItemPair pair) throws MementoContentManagerException {
        StringBuilder collisionMessage = new StringBuilder();
        collisionMessage.append("Unexpected collisions storing items.");
        collisionMessage.append("\nStore providers causing collisions : ");
        for (IMementoStoreProvider storeProvider : collisionProviderCollection) {
            collisionMessage.append("\n" + storeProvider.getDescriptor());
        }
        collisionMessage.append("\nPair for collision : " + pair);
        this.logger.logError(collisionMessage.toString());
        throw new MementoContentManagerException(collisionMessage.toString());
    }

    private void handleStoreStrategyBrokenContracts(Collection<IMementoStoreProvider> brokenStoreProviderCollection) throws MementoContentManagerException {
        StringBuilder brokenContractMessage = new StringBuilder();
        brokenContractMessage.append("Broken store providers: ");
        for (IMementoStoreProvider storeProvider : brokenStoreProviderCollection) {
            brokenContractMessage.append("\n" + storeProvider.getDescriptor());
        }
        this.logger.logError(brokenContractMessage.toString());
        this.storeProviderCollection.removeAll(brokenStoreProviderCollection);
    }
}

