/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.api;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.deeplink.api.AbstractDeepLinkInstanceHandler;
import org.eclipse.e4.core.deeplink.api.Activator;
import org.eclipse.e4.core.deeplink.api.IStatusFactory;
import org.eclipse.e4.core.deeplink.api.ParameterProcessResults;
import org.eclipse.e4.core.deeplink.api.StatusFactory;
import org.eclipse.e4.core.deeplink.api.URLPathInfoParser;
import org.eclipse.e4.core.functionalprog.optionmonad.None;
import org.eclipse.e4.core.functionalprog.optionmonad.Option;
import org.eclipse.e4.core.functionalprog.optionmonad.Some;

public abstract class AbstractDeepLinkTypeHandler {
    public static final String CLASS = "class";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private URLPathInfoParser parsedPathParts;
    public IStatusFactory statusFactory = new StatusFactory();

    public void init(HttpServletRequest request, HttpServletResponse response, URLPathInfoParser pathParts) {
        try {
            request.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        response.setContentType("text/xml");
        this.request = request;
        this.response = response;
        this.parsedPathParts = pathParts;
    }

    public abstract void processDeepLink() throws IOException;

    public void doGet() throws IOException {
        this.processDeepLink();
    }

    public void doPost() throws IOException {
        this.processDeepLink();
    }

    private Option<IConfigurationElement> find(IConfigurationElement[] elementsToLookIn, String idToFind) {
        IConfigurationElement[] iConfigurationElementArray = elementsToLookIn;
        int n = elementsToLookIn.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String id = configurationElement.getAttribute(idToFind);
            if (this.getHandlerId().equals(id)) {
                return Some.some((Object)configurationElement);
            }
            ++n2;
        }
        return None.none();
    }

    protected Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    protected String getHandlerType() {
        return this.parsedPathParts.handlerType;
    }

    protected String getHandlerId() {
        return this.parsedPathParts.handlerId;
    }

    protected String getAction() {
        return (String)this.parsedPathParts.action.getOrSubstitute((Object)"");
    }

    protected void outputResponse(ParameterProcessResults results) throws IOException {
        ServletOutputStream out = this.response.getOutputStream();
        out.println("<?xml version=\"1.0\"?>");
        out.println("<deeplink>");
        out.println("   <result id=\"" + this.parsedPathParts.handlerId + "\" loaded=\"" + results.loaded + "\" callbackRan=\"" + results.activatedParameterCallback + "\"/>");
        if (results.activatedParameterCallback) {
            out.println("   <outputData id=\"" + this.parsedPathParts.handlerId + "\">");
            if (results.outputData != null) {
                for (String key : results.outputData.keySet()) {
                    String value = StringEscapeUtils.escapeXml((String)results.outputData.get(key));
                    out.print("      <element key=\"" + key + "\">");
                    out.print(value);
                    out.println("</element>");
                }
            }
            out.println("   </outputData>");
        }
        out.println("</deeplink>");
    }

    protected IConfigurationElement[] getCongfigElementsFromRegistry(String pluginId, String extPointID) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        return extensionRegistry.getConfigurationElementsFor(pluginId, extPointID);
    }

    protected void findInstanceHandlerAndExecuteCallback(ParameterProcessResults[] results, IConfigurationElement[] congfigElementsFromRegistry, Map<String, String[]> parameters, String extensionPointID) {
        IConfigurationElement configurationElement;
        Option<AbstractDeepLinkInstanceHandler> instanceHandlerOption;
        Option<IConfigurationElement> found = this.find(congfigElementsFromRegistry, extensionPointID);
        if (found.hasValue() && (instanceHandlerOption = this.buildInstanceHandlerFromClassAttribute(configurationElement = (IConfigurationElement)found.get())).hasValue()) {
            AbstractDeepLinkInstanceHandler instanceHandler = (AbstractDeepLinkInstanceHandler)instanceHandlerOption.get();
            instanceHandler.handle(results, this.getHandlerId(), this.getAction(), parameters);
        }
    }

    private Option<AbstractDeepLinkInstanceHandler> buildInstanceHandlerFromClassAttribute(IConfigurationElement configurationElement) {
        try {
            Object interimObject = configurationElement.createExecutableExtension(CLASS);
            if (interimObject instanceof AbstractDeepLinkInstanceHandler) {
                AbstractDeepLinkInstanceHandler handler = (AbstractDeepLinkInstanceHandler)interimObject;
                return Some.some((Object)handler);
            }
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.e4.core.deeplink.handler", "Found extension point but not DeepLinkInstanceHandler: " + configurationElement.getName()));
            return None.none();
        }
        catch (CoreException e) {
            this.logExtensionError(configurationElement.getName(), e);
            return None.none();
        }
    }

    private void logExtensionError(String name, CoreException e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.e4.core.deeplink.handler", "Incorrect extension for: " + name, (Throwable)e));
    }
}

