/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.modeling;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.e4.ui.workbench.swt.modeling.EMenuService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class MenuService
implements EMenuService {
    @Inject
    private MPart myPart;

    public MPopupMenu registerContextMenu(Object parent, String menuId) {
        if (!(parent instanceof Control)) {
            return null;
        }
        Control parentControl = (Control)parent;
        for (MMenu mmenu : this.myPart.getMenus()) {
            if (!menuId.equals(mmenu.getElementId()) || !(mmenu instanceof MPopupMenu)) continue;
            Menu menu = MenuService.registerMenu(parentControl, (MPopupMenu)mmenu, this.myPart);
            if (menu != null) {
                parentControl.setMenu(menu);
                return (MPopupMenu)mmenu;
            }
            return null;
        }
        return null;
    }

    public static Menu registerMenu(Control parentControl, MPopupMenu mmenu, MPart part) {
        MElementContainer parentElement;
        AbstractPartRenderer parentRenderer;
        if (mmenu.getWidget() != null) {
            return (Menu)mmenu.getWidget();
        }
        IRendererFactory rendererFactory = (IRendererFactory)part.getContext().get(IRendererFactory.class);
        AbstractPartRenderer renderer = rendererFactory.getRenderer((MUIElement)mmenu, parentControl);
        IEclipseContext popupContext = part.getContext().createChild("popup:" + mmenu.getElementId());
        mmenu.setContext(popupContext);
        Object widget = renderer.createWidget((MUIElement)mmenu, parentControl);
        if (!(widget instanceof Menu)) {
            return null;
        }
        renderer.bindWidget((MUIElement)mmenu, widget);
        renderer.hookControllerLogic((MUIElement)mmenu);
        MPopupMenu castObject = mmenu;
        renderer.processContents((MElementContainer<MUIElement>)((MElementContainer)castObject));
        renderer.postProcess((MUIElement)mmenu);
        if (mmenu.getParent() instanceof MUIElement && (parentRenderer = rendererFactory.getRenderer((MUIElement)(parentElement = mmenu.getParent()), null)) != null) {
            parentRenderer.childRendered((MElementContainer<MUIElement>)parentElement, (MUIElement)mmenu);
        }
        return (Menu)widget;
    }
}

