/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ClassContributionCollector;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ContributionClassDialog
extends TitleAreaDialog {
    private IProject project;
    private Image javaClassImage;
    private MApplicationElement contribution;
    private EditingDomain editingDomain;
    private TableViewer viewer;
    private EStructuralFeature feature;
    private Messages Messages;

    public ContributionClassDialog(Shell parentShell, IProject project, EditingDomain editingDomain, MApplicationElement contribution, EStructuralFeature feature, Messages Messages2) {
        super(parentShell);
        this.project = project;
        this.contribution = contribution;
        this.editingDomain = editingDomain;
        this.feature = feature;
        this.Messages = Messages2;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.Messages.ContributionClassDialog_ShellTitle);
        this.setTitle(this.Messages.ContributionClassDialog_DialogTitle);
        this.setMessage(this.Messages.ContributionClassDialog_DialogMessage);
        final Image titleImage = new Image((Device)comp.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/wizban/newclass_wiz.png"));
        this.setTitleImage(titleImage);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ContributionClassDialog.this.javaClassImage.dispose();
                titleImage.dispose();
            }
        });
        this.javaClassImage = new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/obj16/class_obj.gif"));
        Composite container = new Composite(comp, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(this.Messages.ContributionClassDialog_Label_Classname);
        final Text t = new Text(container, 2688);
        t.setLayoutData((Object)new GridData(768));
        new Label(container, 0);
        this.viewer = new TableViewer(container);
        GridData gd = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                IClassContributionProvider.ContributionData data = (IClassContributionProvider.ContributionData)cell.getElement();
                StyledString styledString = new StyledString(data.className, null);
                if (data.bundleName != null) {
                    styledString.append(" - " + data.bundleName, StyledString.DECORATIONS_STYLER);
                }
                if (data.sourceType != null) {
                    styledString.append(" - ", StyledString.DECORATIONS_STYLER);
                    styledString.append(String.valueOf(data.sourceType), StyledString.COUNTER_STYLER);
                }
                if (data.iconPath == null) {
                    cell.setImage(ContributionClassDialog.this.javaClassImage);
                }
                cell.setText(styledString.getString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ContributionClassDialog.this.okPressed();
            }
        });
        final WritableList list = new WritableList();
        this.viewer.setInput((Object)list);
        final ClassContributionCollector collector = this.getCollector();
        t.addModifyListener(new ModifyListener(){
            private ContributionResultHandlerImpl currentResultHandler;

            public void modifyText(ModifyEvent e) {
                if (this.currentResultHandler != null) {
                    this.currentResultHandler.cancled = true;
                }
                list.clear();
                this.currentResultHandler = new ContributionResultHandlerImpl((IObservableList)list);
                IClassContributionProvider.Filter filter = new IClassContributionProvider.Filter(ContributionClassDialog.this.project, t.getText());
                collector.findContributions(filter, this.currentResultHandler);
            }
        });
        return comp;
    }

    protected void okPressed() {
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (!s.isEmpty()) {
            IClassContributionProvider.ContributionData cd = (IClassContributionProvider.ContributionData)s.getFirstElement();
            String uri = "platform:/plugin/" + cd.bundleName + "/" + cd.className;
            Command cmd = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.contribution, (Object)this.feature, (Object)uri);
            if (cmd.canExecute()) {
                this.editingDomain.getCommandStack().execute(cmd);
                super.okPressed();
            }
        }
    }

    private ClassContributionCollector getCollector() {
        Bundle bundle = FrameworkUtil.getBundle(ContributionClassDialog.class);
        BundleContext context = bundle.getBundleContext();
        ServiceReference ref = context.getServiceReference(ClassContributionCollector.class.getName());
        if (ref != null) {
            return (ClassContributionCollector)context.getService(ref);
        }
        return null;
    }

    private static class ContributionResultHandlerImpl
    implements IClassContributionProvider.ContributionResultHandler {
        private boolean cancled = false;
        private IObservableList list;

        public ContributionResultHandlerImpl(IObservableList list) {
            this.list = list;
        }

        public void result(IClassContributionProvider.ContributionData data) {
            if (!this.cancled) {
                this.list.add((Object)data);
            }
        }
    }
}

