/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.semantic.examples.remote.Messages;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.SemanticFileRevision;
import org.eclipse.core.resources.semantic.spi.SemanticRevisionStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;

public class RemoteFile
extends RemoteItem {
    public final DateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss_SSS");
    private long lastTime = System.currentTimeMillis();
    long myRemoteTimestamp;
    byte[] myContent;
    final Map<String, byte[]> myVersions = new HashMap<String, byte[]>();
    private final MyBytes myStream;

    public RemoteFile(RemoteStoreTransient store, RemoteFolder parent, String name, byte[] content, long timestamp) {
        super(store, parent, name, RemoteItem.Type.FILE);
        if (parent.getType() != RemoteItem.Type.FOLDER) {
            throw new IllegalArgumentException(Messages.RemoteFile_FilesOnlyUnderFolders_XMSG);
        }
        this.myContent = content;
        this.myRemoteTimestamp = timestamp;
        this.myStream = new MyBytes();
    }

    public byte[] getContent() {
        return this.myContent;
    }

    public ByteArrayOutputStream getOutputStream(boolean append) {
        this.myStream.setAppend(append);
        return this.myStream;
    }

    public long getTimestamp() {
        return this.myRemoteTimestamp;
    }

    public void setTimestamp(long value) {
        this.myRemoteTimestamp = value;
    }

    public IFileHistory getHistory(final ISemanticFileStore store) {
        ArrayList<1> revisions = new ArrayList<1>();
        for (final Map.Entry<String, byte[]> entry : this.myVersions.entrySet()) {
            long time = Long.parseLong(entry.getKey());
            String name = NLS.bind((String)Messages.RemoteFile_Version_XGRP, (Object)this.format.format(new Date(time)));
            revisions.add(new SemanticFileRevision(store, time, "", name){

                public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                    SemanticRevisionStorage storage = new SemanticRevisionStorage(store);
                    storage.setContents((InputStream)new ByteArrayInputStream((byte[])entry.getValue()), monitor);
                    return storage;
                }
            });
        }
        revisions.add(this.getCurrentRevision(store));
        final IFileRevision[] revs = revisions.toArray(new IFileRevision[0]);
        return new IFileHistory(){

            public IFileRevision[] getTargets(IFileRevision revision) {
                return null;
            }

            public IFileRevision[] getFileRevisions() {
                return revs;
            }

            public IFileRevision getFileRevision(String id) {
                IFileRevision[] iFileRevisionArray = this.getFileRevisions();
                int n = iFileRevisionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileRevision rev = iFileRevisionArray[n2];
                    if (rev.getContentIdentifier().equals(id)) {
                        return rev;
                    }
                    ++n2;
                }
                return null;
            }

            public IFileRevision[] getContributors(IFileRevision revision) {
                return null;
            }
        };
    }

    public IFileRevision getCurrentRevision(final ISemanticFileStore store) {
        String name = NLS.bind((String)Messages.RemoteFile_Current_XGRP, (Object)this.format.format(new Date(this.getTimestamp())));
        return new SemanticFileRevision(store, this.getTimestamp(), "", name){

            public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                SemanticRevisionStorage storage = new SemanticRevisionStorage(store);
                storage.setContents((InputStream)new ByteArrayInputStream(RemoteFile.this.myContent), monitor);
                return storage;
            }
        };
    }

    synchronized long newTime() {
        long actTime = this.lastTime;
        try {
            actTime = System.currentTimeMillis();
            if (actTime > this.lastTime) {
                long l = actTime;
                return l;
            }
            int add = 1;
            while (actTime <= this.lastTime) {
                actTime = System.currentTimeMillis() + (long)add;
                ++add;
            }
            long l = actTime;
            return l;
        }
        finally {
            this.lastTime = actTime;
        }
    }

    final class MyBytes
    extends ByteArrayOutputStream {
        private boolean isOpen = false;

        MyBytes() {
        }

        public synchronized void write(byte[] b, int off, int len) {
            this.isOpen = true;
            super.write(b, off, len);
        }

        public synchronized void write(int b) {
            this.isOpen = true;
            super.write(b);
        }

        public synchronized void write(byte[] b) throws IOException {
            this.isOpen = true;
            super.write(b);
        }

        public synchronized void close() throws IOException {
            super.close();
            if (this.isOpen) {
                RemoteFile.this.myVersions.put(Long.toString(RemoteFile.this.myRemoteTimestamp), RemoteFile.this.myContent);
                RemoteFile.this.myContent = this.toByteArray();
                RemoteFile.this.myRemoteTimestamp = RemoteFile.this.newTime();
                this.isOpen = false;
            }
        }

        public synchronized void reset() {
            super.reset();
            if (this.isOpen) {
                this.isOpen = false;
            }
        }

        public synchronized void setAppend(boolean append) {
            if (!append) {
                super.reset();
                this.isOpen = true;
            }
        }
    }
}

