/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.resources.semantic.test.TestsContentProviderBase;
import org.eclipse.core.resources.semantic.test.provider.CachingTestContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.junit.Test;

public class TestsCachingProvider2
extends TestsContentProviderBase {
    private RemoteFile file1;

    public void afterMethod() throws Exception {
        super.afterMethod();
        this.file1 = null;
    }

    public void beforeMethod() throws Exception {
        super.beforeMethod();
        RemoteStoreTransient store = (RemoteStoreTransient)this.testProject.getAdapter(RemoteStoreTransient.class);
        this.file1 = (RemoteFile)store.getItemByPath((IPath)new Path("Folder1/File1"));
    }

    public RemoteFile getRemoteFile() {
        return this.file1;
    }

    public TestsCachingProvider2() {
        super(true, "CachingTests", CachingTestContentProvider.class.getName());
    }

    @Test
    public void testAddFileFromRemoteDeleteAndAddAgain() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        Assert.assertEquals((String)"Folder existence", (boolean)false, (boolean)parent.exists());
        final IFile file = parent.getFile("File1");
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                ISemanticFile sfile = sfr.addFile("File1", TestsCachingProvider2.this.options, monitor);
                Assert.assertTrue((boolean)sfile.getAdaptedFile().equals((Object)file));
                InputStream is = null;
                try {
                    is = sfile.getAdaptedFile().getContents();
                    try {
                        Assert.assertTrue((String)"Too few bytes available", (is.available() > 0 ? 1 : 0) != 0);
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                finally {
                    Util.safeClose((InputStream)is);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
        Assert.assertEquals((String)"Folder existence", (boolean)true, (boolean)parent.exists());
        InputStream is = file.getContents();
        try {
            runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ISemanticFile sFile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                    try {
                        sFile.remove(TestsCachingProvider2.this.options, monitor);
                    }
                    catch (CoreException coreException) {
                        Assert.fail((String)"Remove failure");
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((String)"File exsistence", (boolean)false, (boolean)file.exists());
            runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                    ISemanticFile sfile = sfr.addFile("File1", TestsCachingProvider2.this.options, monitor);
                    Assert.assertTrue((boolean)sfile.getAdaptedFile().equals((Object)file));
                    InputStream is1 = null;
                    try {
                        is1 = sfile.getAdaptedFile().getContents();
                        try {
                            Assert.assertTrue((String)"Too few bytes available", (is1.available() > 0 ? 1 : 0) != 0);
                        }
                        catch (IOException e) {
                            Assert.fail((String)e.getMessage());
                        }
                    }
                    finally {
                        Util.safeClose((InputStream)is1);
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                Assert.fail((String)"Should not fail");
            }
        }
        finally {
            Util.safeClose((InputStream)is);
        }
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
    }
}

