/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.e4.emf.ecore.javascript.AbstractJavascriptTest;
import org.eclipse.emf.ecore.EObject;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreJavascriptTest
extends AbstractJavascriptTest {
    protected void setUp() throws Exception {
        this.setUp("ecoreJavascriptTest.xmi");
    }

    private Object evalScript(Object scopePrototype, String script) {
        return this.evalScript((Scriptable)this.javascriptSupport.wrap(scopePrototype), script);
    }

    private Object evalScript(Scriptable scopePrototype, String script) {
        Scriptable scope = (Scriptable)this.javascriptSupport.wrap((Object)scopePrototype);
        scope.setParentScope(this.javascriptSupport.getScope((Object)scopePrototype));
        if (!script.startsWith("return")) {
            script = "return " + script;
        }
        script = "function ScriptScrapBookView() { " + script + "}";
        Object result = this.javascriptSupport.evaluate(script, (Object)scope, true);
        result = this.javascriptSupport.callMethod((Object)scope, "ScriptScrapBookView", null, true);
        return result;
    }

    public void testEcoreIsA() {
        EObject c1 = this.id2EObject("c1");
        String isAScript = "return this.isA($ecoreJavascriptTest.$C1);";
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(c1, isAScript));
    }

    public void testEcoreFindContainer() {
        EObject c1 = this.id2EObject("c1");
        EObject c11 = this.id2EObject("c11");
        EObject c211 = this.id2EObject("c211");
        String isAScript = "return this.findContainer($ecoreJavascriptTest.$C1);";
        EcoreJavascriptTest.assertEquals((Object)c11, (Object)this.evalScript(c211, isAScript));
        EcoreJavascriptTest.assertEquals((Object)c1, (Object)this.evalScript(c11, isAScript));
        EcoreJavascriptTest.assertEquals(null, (Object)this.evalScript(c1, isAScript));
    }

    public void testEcoreContains() {
        String resourceContainsScript = "return this._().contains($(this, 'c1'));";
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(this.resource, resourceContainsScript));
        String eObjectContainsScript = "return this._().contains($(this, 'c21'));";
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(this.resource.getContents().get(0), eObjectContainsScript));
        String resourceSetContainsScript = "return this.resourceSet._().contains(this);";
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(this.resource, resourceSetContainsScript));
    }

    public void testFilter() {
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(this.resource, "this._().filter(false);"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(this.resource, "this._().filter(null);"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(this.resource, "this._().filter(0.0);"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(this.resource, "this._().filter(undefined);"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(this.resource, "this._().filter(true);"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(this.resource, "this._().filter(1.0);"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(this.resource, "this._().filter('string');"));
    }

    private EObject id2EObject(String id) {
        return this.resource.getEObject(id);
    }

    public void testFindOne() {
        EObject c1 = this.id2EObject("c1");
        Object undefined = this.evalScript(c1, "undefined");
        EcoreJavascriptTest.assertEquals((Object)this.id2EObject("c22"), (Object)this.evalScript(c1, "this._().findOne(function (arg) { return arg.name == 'c22';});"));
        EcoreJavascriptTest.assertEquals((Object)this.id2EObject("c22"), (Object)this.evalScript(c1, "this._().findOne(function (arg) { return arg.name == 'c22';}, 1);"));
        EcoreJavascriptTest.assertEquals((Object)undefined, (Object)this.evalScript(c1, "this._().findOne(function (arg) { return arg.name == 'c212';}, 0);"));
        EcoreJavascriptTest.assertEquals((Object)this.id2EObject("c212"), (Object)this.evalScript(c1, "this._().findOne(function (arg) { return arg.name == 'c212';}, 1);"));
    }

    private void testContainsSame(List<?> l1, List<?> l2) {
        EcoreJavascriptTest.assertTrue((String)("The sizes, " + l1.size() + " and " + l2.size() + ", are not the same"), (l1.size() == l2.size() ? 1 : 0) != 0);
        EcoreJavascriptTest.assertTrue((String)(l1 + " and " + l2 + " are not the same"), (l1.containsAll(l2) && l2.containsAll(l1) ? 1 : 0) != 0);
    }

    private void testContainsSame(List<?> l1, Object o) {
        EcoreJavascriptTest.assertTrue((boolean)(o instanceof List));
        this.testContainsSame(l1, (List)o);
    }

    private List<?> asList(String ... ids) {
        ArrayList<EObject> result = new ArrayList<EObject>(ids.length);
        int i = 0;
        while (i < ids.length) {
            result.add(this.id2EObject(ids[i]));
            ++i;
        }
        return result;
    }

    public void testNewList() {
        EObject c1 = this.id2EObject("c1");
        Object original = this.evalScript(c1, "this._();");
        Object copy = this.evalScript(c1, "this._().newList(this._());");
        EcoreJavascriptTest.assertTrue((boolean)(original instanceof List));
        EcoreJavascriptTest.assertTrue((boolean)(copy instanceof List));
        EcoreJavascriptTest.assertNotSame((Object)original, (Object)copy);
        EcoreJavascriptTest.assertEquals((Object)original, (Object)copy);
        Object list = this.evalScript(c1, "this._().newList(this._().size());");
        EcoreJavascriptTest.assertTrue((boolean)(list instanceof List));
        EcoreJavascriptTest.assertEquals((int)0, (int)((List)list).size());
    }

    public void testFindMany() {
        EObject c1 = this.id2EObject("c1");
        this.testContainsSame(this.asList("c21", "c22"), this.evalScript(c1, "this._().findMany(function (arg) { return arg.name.substring(0,2) == 'c2';});"));
        this.testContainsSame(this.asList("c21", "c22", "c211", "c212", "c221", "c222"), this.evalScript(c1, "this._().findMany(function (arg) { return arg.name.substring(0,2) == 'c2';}, 1);"));
        this.testContainsSame(this.asList("c21", "c22", "c211", "c212", "c221", "c222"), this.evalScript(c1, "this._().findMany(function (arg) { return arg.name.substring(0,2) == 'c2';}, -1);"));
    }

    public void testFindInstances() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertSame((Object)c1.eClass(), (Object)this.evalScript(this.resource, "$ecoreJavascriptTest.$C1;"));
        this.testContainsSame(this.asList("c1", "c11", "c12"), this.evalScript(this.resource, "this._().findInstances($ecoreJavascriptTest.$C1);"));
        this.testContainsSame(this.asList("c21", "c22", "c211", "c212", "c221", "c222", "c31", "c311", "c321"), this.evalScript(this.resource, "this._().findInstances($ecoreJavascriptTest.$C2);"));
        this.testContainsSame(this.asList("c31", "c311", "c321"), this.evalScript(this.resource, "this._().findInstances($ecoreJavascriptTest.$C3);"));
        this.testContainsSame(this.asList("c11", "c12"), this.evalScript(c1, "this._().findInstances($ecoreJavascriptTest.$C1);"));
        this.testContainsSame(this.asList("c21", "c22", "c211", "c212", "c221", "c222", "c31", "c311", "c321"), this.evalScript(c1, "this._().findInstances($ecoreJavascriptTest.$C2);"));
        this.testContainsSame(this.asList("c31", "c311", "c321"), this.evalScript(c1, "this._().findInstances($ecoreJavascriptTest.$C3);"));
    }

    public void testFindInstancesGen() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertSame((Object)c1.eClass(), (Object)this.evalScript(this.resource, "$ecoreJavascriptTest.$C1;"));
        this.testContainsSame(this.asList("c1", "c11", "c12"), this.evalScript(this.resource, "this._().findInstancesGen($ecoreJavascriptTest.$C1);"));
        this.testContainsSame(this.asList("c21", "c22", "c211", "c212", "c221", "c222", "c31", "c311", "c321"), this.evalScript(this.resource, "this._().findInstancesGen($ecoreJavascriptTest.$C2);"));
        this.testContainsSame(this.asList("c31", "c311", "c321"), this.evalScript(this.resource, "this._().findInstancesGen($ecoreJavascriptTest.$C3);"));
        this.testContainsSame(this.asList("c11", "c12"), this.evalScript(c1, "this._().findInstancesGen($ecoreJavascriptTest.$C1);"));
        this.testContainsSame(this.asList("c21", "c22", "c211", "c212", "c221", "c222", "c31", "c311", "c321"), this.evalScript(c1, "this._().findInstancesGen($ecoreJavascriptTest.$C2);"));
        this.testContainsSame(this.asList("c31", "c311", "c321"), this.evalScript(c1, "this._().findInstancesGen($ecoreJavascriptTest.$C3);"));
    }

    public void testFindInstance() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertSame((Object)c1.eClass(), (Object)this.evalScript(this.resource, "$ecoreJavascriptTest.$C1;"));
        EcoreJavascriptTest.assertEquals((Object)this.id2EObject("c11"), (Object)this.evalScript(c1, "this._().findInstance($ecoreJavascriptTest.$C1);"));
        EcoreJavascriptTest.assertEquals((Object)this.id2EObject("c21"), (Object)this.evalScript(c1, "this._().findInstance($ecoreJavascriptTest.$C2);"));
        EcoreJavascriptTest.assertEquals((Object)this.id2EObject("c31"), (Object)this.evalScript(c1, "this._().findInstance($ecoreJavascriptTest.$C3);"));
    }

    public void testFindInstanceGen() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertSame((Object)c1.eClass(), (Object)this.evalScript(this.resource, "$ecoreJavascriptTest.$C1;"));
        EcoreJavascriptTest.assertEquals((Object)this.id2EObject("c11"), (Object)this.evalScript(c1, "this._().findInstanceGen($ecoreJavascriptTest.$C1);"));
        EcoreJavascriptTest.assertEquals((Object)this.id2EObject("c21"), (Object)this.evalScript(c1, "this._().findInstanceGen($ecoreJavascriptTest.$C2);"));
        EcoreJavascriptTest.assertEquals((Object)this.id2EObject("c31"), (Object)this.evalScript(c1, "this._().findInstanceGen($ecoreJavascriptTest.$C3);"));
    }

    public void testMapList() {
        EObject c1 = this.id2EObject("c1");
        Object undefined = this.evalScript(c1, "undefined");
        EcoreJavascriptTest.assertEquals(Arrays.asList("c21", "c22", "c31", "c11", "c12"), (Object)this.evalScript(c1, "this._().mapList('name');"));
        EcoreJavascriptTest.assertEquals(Arrays.asList(21.0, 22.0, 31.0, undefined, undefined), (Object)this.evalScript(c1, "this._().mapList('value');"));
        EcoreJavascriptTest.assertEquals(Arrays.asList(42.0, 44.0, 62.0, 0.0, 0.0), (Object)this.evalScript(c1, "this._().mapList(function (c) { var value = c.value; return value == undefined ? 0.0 : value * 2;});"));
    }

    public void testMapListGen() {
        EObject c1 = this.id2EObject("c1");
        Object undefined = this.evalScript(c1, "undefined");
        EcoreJavascriptTest.assertEquals(Arrays.asList("c21", "c22", "c31", "c11", "c12"), (Object)this.evalScript(c1, "this._().mapListGen('name');"));
        EcoreJavascriptTest.assertEquals(Arrays.asList(21.0, 22.0, 31.0, undefined, undefined), (Object)this.evalScript(c1, "this._().mapListGen('value');"));
        EcoreJavascriptTest.assertEquals(Arrays.asList(42.0, 44.0, 62.0, 0.0, 0.0), (Object)this.evalScript(c1, "this._().mapListGen(function (c) { var value = c.value; return value == undefined ? 0.0 : value * 2;});"));
    }

    public void testMap() {
        EObject c1 = this.id2EObject("c1");
        Object undefined = this.evalScript(c1, "undefined");
        EcoreJavascriptTest.assertEquals(Arrays.asList("c21", "c22", "c31", "c11", "c12"), (Object)this.evalScript(c1, "this._().map('name');"));
        EcoreJavascriptTest.assertEquals(Arrays.asList(21.0, 22.0, 31.0, undefined, undefined), (Object)this.evalScript(c1, "this._().map('value');"));
        EcoreJavascriptTest.assertEquals(Arrays.asList(42.0, 44.0, 62.0, 0.0, 0.0), (Object)this.evalScript(c1, "this._().mapList(function (c) { var value = c.value; return value == undefined ? 0.0 : value * 2;});"));
    }

    public void testMapProperty() {
        EObject c1 = this.id2EObject("c1");
        Object undefined = this.evalScript(c1, "undefined");
        EcoreJavascriptTest.assertEquals(Arrays.asList("c21", "c22", "c31", "c11", "c12"), (Object)this.evalScript(c1, "this._().mapProperty('name');"));
        EcoreJavascriptTest.assertEquals(Arrays.asList(21.0, 22.0, 31.0, undefined, undefined), (Object)this.evalScript(c1, "this._().mapProperty('value');"));
    }

    public void testReduce() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertEquals((Object)148.0, (Object)this.evalScript(c1, "this._().reduce(function (res,c) { var value = c.value; return res + (value == undefined ? 0.0 : value * 2);}, 0.0);"));
        EcoreJavascriptTest.assertEquals(Arrays.asList("c21", "c22", "c31", "c11", "c12"), (Object)this.evalScript(c1, "this._().reduce(function (res,c) { res.add(c.name); return res;}, new java.util.ArrayList());"));
    }

    public void testFilterList() {
        EObject c1 = this.id2EObject("c1");
        this.testContainsSame(this.asList("c11", "c12"), this.evalScript(c1, "this._().filterList(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
        this.testContainsSame(this.asList("c21", "c22", "c31"), this.evalScript(c1, "this._().filterList(function (c) { return c.isA($ecoreJavascriptTest.$C1);}, false)"));
    }

    public void testFilterListGen() {
        EObject c1 = this.id2EObject("c1");
        this.testContainsSame(this.asList("c11", "c12"), this.evalScript(c1, "this._().filterListGen(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
        this.testContainsSame(this.asList("c21", "c22", "c31"), this.evalScript(c1, "this._().filterListGen(function (c) { return c.isA($ecoreJavascriptTest.$C1);}, false)"));
    }

    public void testSelect() {
        EObject c1 = this.id2EObject("c1");
        this.testContainsSame(this.asList("c11", "c12"), this.evalScript(c1, "this._().select(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
    }

    public void testReject() {
        EObject c1 = this.id2EObject("c1");
        this.testContainsSame(this.asList("c21", "c22", "c31"), this.evalScript(c1, "this._().reject(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
    }

    public void testCountList() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertEquals((Object)2.0, (Object)this.evalScript(c1, "this._().countList(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
        EcoreJavascriptTest.assertEquals((Object)3.0, (Object)this.evalScript(c1, "this._().countList(function (c) { return c.isA($ecoreJavascriptTest.$C1);}, false)"));
    }

    public void testCountListGen() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertEquals((Object)2.0, (Object)this.evalScript(c1, "this._().countListGen(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
        EcoreJavascriptTest.assertEquals((Object)3.0, (Object)this.evalScript(c1, "this._().countListGen(function (c) { return c.isA($ecoreJavascriptTest.$C1);}, false)"));
    }

    public void testCount() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertEquals((Object)2.0, (Object)this.evalScript(c1, "this._().count(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
        EcoreJavascriptTest.assertEquals((Object)3.0, (Object)this.evalScript(c1, "this._().count(function (c) { return c.isA($ecoreJavascriptTest.$C2);})"));
        EcoreJavascriptTest.assertEquals((Object)1.0, (Object)this.evalScript(c1, "this._().count(function (c) { return c.isA($ecoreJavascriptTest.$C3);})"));
    }

    public void testSingle() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(c1, "this._().single(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(c1, "this._().single(function (c) { return c.isA($ecoreJavascriptTest.$C2);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(c1, "this._().single(function (c) { return c.isA($ecoreJavascriptTest.$C3);})"));
    }

    public void testExists() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(c1, "this._().exists(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(c1, "this._().exists(function (c) { return c.isA($ecoreJavascriptTest.$C2);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(c1, "this._().exists(function (c) { return c.isA($ecoreJavascriptTest.$C3);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(c1, "this._().exists(function (c) { return c.name == 'c';})"));
    }

    public void testEvery() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(c1, "this._().every(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(c1, "this._().every(function (c) { return c.isA($ecoreJavascriptTest.$C2);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(c1, "this._().every(function (c) { return c.isA($ecoreJavascriptTest.$C3);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(c1, "this._().every(function (c) { return c.name != undefined;})"));
    }

    public void testNone() {
        EObject c1 = this.id2EObject("c1");
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(c1, "this._().none(function (c) { return c.isA($ecoreJavascriptTest.$C1);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(c1, "this._().none(function (c) { return c.isA($ecoreJavascriptTest.$C2);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.FALSE, (Object)this.evalScript(c1, "this._().none(function (c) { return c.isA($ecoreJavascriptTest.$C3);})"));
        EcoreJavascriptTest.assertEquals((Object)Boolean.TRUE, (Object)this.evalScript(c1, "this._().none(function (c) { return c.name == undefined;})"));
    }

    public void testListWith() {
        List<Double> list1 = Arrays.asList(1.0, 2.0, 3.0);
        List<Double> list2 = Arrays.asList(1.0, 2.0, 3.0, 4.0);
        Object result1 = this.evalScript(list1, "this.listWith(1.0);");
        EcoreJavascriptTest.assertSame(list1, (Object)result1);
        Object result2 = this.evalScript(list1, "this.listWith(4.0);");
        EcoreJavascriptTest.assertEquals(list2, (Object)result2);
    }

    public void testListWithout() {
        List<Double> list1 = Arrays.asList(1.0, 2.0, 3.0);
        List<Double> list2 = Arrays.asList(1.0, 2.0, 4.0, 3.0, 4.0);
        Object result1 = this.evalScript(list1, "this.listWithout(4.0);");
        EcoreJavascriptTest.assertSame(list1, (Object)result1);
        Object result2 = this.evalScript(list2, "this.listWithout(4.0);");
        EcoreJavascriptTest.assertEquals(list1, (Object)result2);
    }
}

