/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.policies.layout;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Polyline;
import org.eclipse.e4.xwt.tools.ui.designer.commands.MoveChildCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.RowLayoutCommandsFactory;
import org.eclipse.e4.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.e4.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.policies.NewResizableEditPolicy;
import org.eclipse.e4.xwt.tools.ui.designer.policies.feedback.FeedbackHelper;
import org.eclipse.e4.xwt.tools.ui.designer.policies.feedback.FeedbackManager;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.ILayoutEditPolicy;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Layout;

public class RowLayoutEditPolicy
extends FlowLayoutEditPolicy
implements ILayoutEditPolicy {
    private static final int HORIZONTAL = 256;
    protected int type = 256;
    private FeedbackManager fbm = new FeedbackManager((GraphicalEditPolicy)this);

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NewResizableEditPolicy(20, true);
    }

    protected Polyline getLineFeedback() {
        Polyline polyline = super.getLineFeedback();
        polyline.setForegroundColor(ColorConstants.red);
        return polyline;
    }

    protected boolean isHorizontal() {
        return this.type == 256;
    }

    public void activate() {
        super.activate();
        this.determineType();
    }

    protected void determineType() {
        EditPart host = this.getHost();
        if (!(host instanceof CompositeEditPart)) {
            return;
        }
        CompositeEditPart composite = (CompositeEditPart)host;
        Layout layout = composite.getLayout();
        if (layout != null && layout instanceof RowLayout) {
            this.type = ((RowLayout)layout).type;
        }
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        return null;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        return new MoveChildCommand(child, after);
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            return this.getResizeCommand(request);
        }
        return super.getCommand(request);
    }

    private Command getResizeCommand(Request request) {
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        CompoundCommand resize = new CompoundCommand();
        List children = req.getEditParts();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            Command c = this.createResizeChildrenCommand(request, (EditPart)child, req.getSizeDelta());
            resize.add(c);
            ++i;
        }
        return resize.unwrap();
    }

    protected Command createResizeChildrenCommand(Request request, EditPart child, Object newSize) {
        RowLayoutCommandsFactory factory = new RowLayoutCommandsFactory(child);
        return factory.getResizeChildCommand(newSize);
    }

    protected Command getCreateCommand(CreateRequest request) {
        RowLayoutCommandsFactory factory = new RowLayoutCommandsFactory(this.getHost());
        EditPart insertionReference = this.getInsertionReference((Request)request);
        return factory.getCreateCommand(request, insertionReference);
    }

    protected Command getDeleteDependantCommand(Request request) {
        RowLayoutCommandsFactory factory = new RowLayoutCommandsFactory(this.getHost());
        return factory.getDeleteCommand(request);
    }

    protected void showLayoutTargetFeedback(Request request) {
        if ("create child".equals(request.getType())) {
            if (!FeedbackHelper.showCreationFeedback(this.fbm, (CreateRequest)request)) {
                super.showLayoutTargetFeedback(request);
            }
        } else {
            super.showLayoutTargetFeedback(request);
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.fbm.eraseFeedback(request);
        super.eraseLayoutTargetFeedback(request);
    }

    public void refresh() {
    }

    public LayoutType getType() {
        return LayoutType.RowLayout;
    }
}

