/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.graphics.util;

import org.eclipse.e4.tm.graphics.util.AbstractCloneable;
import org.eclipse.e4.tm.graphics.util.Point;
import org.eclipse.e4.tm.graphics.util.Util;

public class Transform
extends AbstractCloneable {
    public double a11;
    public double a12;
    public double b1;
    public double a21;
    public double a22;
    public double b2;
    private static String toStringPrefix = "";
    private static String toStringSuffix = "";
    private static Transform tTemp = new Transform();
    private static Point pTemp = new Point();
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;

    public Transform() {
        this(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public Transform(double a11, double a21, double a12, double a22, double b1, double b2) {
        this.a11 = a11;
        this.a12 = a12;
        this.a21 = a21;
        this.a22 = a22;
        this.b1 = b1;
        this.b2 = b2;
    }

    public Transform(Transform t) {
        this(t.a11, t.a21, t.a12, t.a22, t.b1, t.b2);
    }

    public Transform(double[] t) {
        this(t[0], t[1], t[2], t[3], t.length > 5 ? t[4] : 0.0, t.length > 5 ? t[5] : 0.0);
    }

    public Transform(float a11, float a21, float a12, float a22, float b1, float b2) {
        this.a11 = a11;
        this.a12 = a12;
        this.a21 = a21;
        this.a22 = a22;
        this.b1 = b1;
        this.b2 = b2;
    }

    public Transform(float[] t) {
        this((double)t[0], (double)t[1], (double)t[2], (double)t[3], t.length > 4 ? (double)t[4] : 0.0, t.length > 4 ? (double)t[5] : 0.0);
    }

    public String toString() {
        return String.valueOf(toStringPrefix) + "x'=" + this.a11 + "*x+" + this.a12 + "*y+" + this.b1 + ";y'=" + this.a12 + "*x+" + this.a22 + "*y+" + this.b2 + toStringSuffix;
    }

    public static Transform valueOf(String s) {
        double[] doubles = Util.valueOf(s, toStringPrefix, "(;?(x|y)'=)|(\\*(x|y)\\+)", toStringSuffix);
        return new Transform(doubles[0], doubles[3], doubles[1], doubles[4], doubles[2], doubles[5]);
    }

    public double getTranslateX() {
        return this.b1;
    }

    public double getTranslateY() {
        return this.b2;
    }

    public double getScaleX() {
        return this.a11;
    }

    public double getScaleY() {
        return this.a22;
    }

    public double getShearX() {
        return this.a12;
    }

    public double getShearY() {
        return this.a21;
    }

    public void getMatrix(double[] t) {
        t[0] = this.a11;
        t[1] = this.a21;
        t[2] = this.a12;
        t[3] = this.a22;
        if (t.length > 5) {
            t[4] = this.b1;
            t[5] = this.b2;
        }
    }

    public Transform setTransform(double a11, double a21, double a12, double a22, double b1, double b2) {
        this.a11 = a11;
        this.a12 = a12;
        this.a21 = a21;
        this.a22 = a22;
        this.b1 = b1;
        this.b2 = b2;
        return this;
    }

    public Transform setTransform(Transform t) {
        return this.setTransform(t.a11, t.a21, t.a12, t.a22, t.b1, t.b2);
    }

    public Transform setToIdentity() {
        return this.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public Transform setToTranslation(double dx, double dy) {
        return this.setTransform(1.0, 0.0, 0.0, 1.0, dx, dy);
    }

    public Transform setToScale(double sx, double sy) {
        return this.setTransform(sx, 0.0, 0.0, sy, 0.0, 0.0);
    }

    public Transform setToRotation(double radians) {
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        return this.setTransform(cos, sin, -sin, cos, 0.0, 0.0);
    }

    public Transform setToRotation(double radians, double x, double y) {
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        return this.setTransform(cos, sin, -sin, cos, x - x * cos + y * sin, y - x * sin - y * cos);
    }

    public static Transform concatenate(Transform t1, Transform t2, Transform dest) {
        if (dest == null) {
            dest = new Transform();
        }
        return dest.setTransform(t1.a11 * t2.a11 + t1.a12 * t2.a21, t1.a21 * t2.a11 + t1.a22 * t2.a21, t1.a11 * t2.a12 + t1.a12 * t2.a22, t1.a21 * t2.a12 + t1.a22 * t2.a22, t1.a11 * t2.b1 + t1.a12 * t2.b2 + t1.b1, t1.a21 * t2.b1 + t1.a22 * t2.b2 + t1.b2);
    }

    public Transform concatenate(Transform t) {
        return Transform.concatenate(this, t, this);
    }

    public Transform preConcatenate(Transform t) {
        return Transform.concatenate(t, this, this);
    }

    public Transform translate(double dx, double dy) {
        return this.concatenate(tTemp.setToTranslation(dx, dy));
    }

    public Transform scale(double sx, double sy) {
        return this.concatenate(tTemp.setToScale(sx, sy));
    }

    public Transform rotate(double radians) {
        return this.concatenate(tTemp.setToRotation(radians));
    }

    public Transform rotate(double radians, double x, double y) {
        return this.concatenate(tTemp.setToRotation(radians, x, y));
    }

    private static Point transform(double x, double y, Point dest, Transform t, boolean delta) {
        if (dest == null) {
            dest = new Point();
        }
        dest.x = x * t.a11 + y * t.a12 + (delta ? 0.0 : t.b1);
        dest.y = x * t.a21 + y * t.a22 + (delta ? 0.0 : t.b2);
        return dest;
    }

    public Point transform(Point p, Point dest) {
        return Transform.transform(p.x, p.y, dest, this, false);
    }

    public Point deltaTransform(Point p, Point dest) {
        return Transform.transform(p.x, p.y, dest, this, true);
    }

    private void transform(double[] src, int srcPos, double[] dest, int destPos, int numPoints, boolean delta) {
        if (dest == null) {
            dest = new double[destPos + numPoints * 2];
        }
        System.arraycopy(src, srcPos, dest, destPos, numPoints * 2);
        int i = 0;
        while (i < numPoints) {
            Transform.pTemp.x = dest[destPos + i];
            Transform.pTemp.y = dest[destPos + i + 1];
            Transform.transform(Transform.pTemp.x, Transform.pTemp.y, pTemp, this, delta);
            dest[destPos + i] = Transform.pTemp.x;
            dest[destPos + i + 1] = Transform.pTemp.y;
            i += 2;
        }
    }

    public void transform(double[] src, int srcPos, double[] dest, int destPos, int numPoints) {
        this.transform(src, srcPos, dest, destPos, numPoints, false);
    }

    public void deltaTransform(double[] src, int srcPos, double[] dest, int destPos, int numPoints) {
        this.transform(src, srcPos, dest, destPos, numPoints, true);
    }

    private static Transform invert(Transform t, Transform dest) throws Exception {
        double det = t.a11 * t.a22 - t.a12 * t.a21;
        if (Math.abs(det) < Double.MIN_VALUE) {
            throw new Exception(t + " is not invertible");
        }
        if (dest == null) {
            dest = new Transform();
        }
        return dest.setTransform(t.a22 / det, -t.a21 / det, -t.a12 / det, t.a11 / det, (t.a12 * t.b2 - t.a22 * t.b1) / det, (t.a21 * t.b1 - t.a11 * t.b2) / det);
    }

    public Transform createInverse() throws Exception {
        return Transform.invert(this, new Transform());
    }

    private Point inverseTransform(double x, double y, Point dest, Transform t) throws Exception {
        double det = t.a11 * t.a22 - t.a12 * t.a21;
        if (Math.abs(det) < Double.MIN_VALUE) {
            throw new Exception(t + " is not invertible");
        }
        double dx = x - t.b1;
        double dy = y - t.b2;
        if (dest == null) {
            dest = new Point();
        }
        dest.x = (t.a22 * dx - t.a12 * dy) / det;
        dest.y = (t.a11 * dy - t.a21 * dx) / det;
        return dest;
    }

    public Point inverseTransform(Point p, Point dest) throws Exception {
        return this.inverseTransform(p.x, p.y, dest, this);
    }

    public void inverseTransform(double[] src, int srcPos, double[] dest, int destPos, int numPoints) throws Exception {
        if (dest == null) {
            dest = new double[destPos + numPoints * 2];
        }
        System.arraycopy(src, srcPos, dest, destPos, numPoints * 2);
        int i = 0;
        while (i < numPoints) {
            Transform.pTemp.x = dest[destPos + i];
            Transform.pTemp.y = dest[destPos + i + 1];
            this.inverseTransform(Transform.pTemp.x, Transform.pTemp.y, pTemp, this);
            dest[destPos + i] = Transform.pTemp.x;
            dest[destPos + i + 1] = Transform.pTemp.y;
            i += 2;
        }
    }

    public int getType() {
        int bits = 0;
        if (this.b1 != 0.0 || this.b2 == 0.0) {
            bits |= 1;
        }
        if (this.a11 != 1.0 || this.a22 != 1.0) {
            bits |= this.a11 == this.a22 ? 2 : 4;
        }
        return bits;
    }
}

