/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.BindingServiceAddon;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MMenuItemTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.appContext);
        ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.appContext);
        ContextInjectionFactory.make(BindingServiceAddon.class, (IEclipseContext)this.appContext);
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    private void testMMenuItem_Text(String before, String beforeExpected, String after, String afterExpected) {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem.setLabel(before);
        window.setMainMenu(menu);
        menu.getChildren().add(menuItem);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        ((MenuManager)((Widget)menu.getWidget()).getData()).updateAll(true);
        Object widget = menuItem.getWidget();
        MMenuItemTest.assertNotNull((Object)widget);
        MMenuItemTest.assertTrue((boolean)(widget instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget;
        MMenuItemTest.assertEquals((String)beforeExpected, (String)menuItemWidget.getText());
        menuItem.setLabel(after);
        MMenuItemTest.assertEquals((String)afterExpected, (String)menuItemWidget.getText());
    }

    public void testMMenuItem_Text_NullNull() {
        this.testMMenuItem_Text(null, "", null, "");
    }

    public void testMMenuItem_Text_NullEmpty() {
        this.testMMenuItem_Text(null, "", "", "");
    }

    public void testMMenuItem_Text_NullString() {
        this.testMMenuItem_Text(null, "", "label", "label");
    }

    public void testMMenuItem_Text_EmptyNull() {
        this.testMMenuItem_Text("", "", null, "");
    }

    public void testMMenuItem_Text_EmptyEmpty() {
        this.testMMenuItem_Text("", "", "", "");
    }

    public void testMMenuItem_Text_EmptyString() {
        this.testMMenuItem_Text("", "", "label", "label");
    }

    public void testMMenuItem_Text_StringNull() {
        this.testMMenuItem_Text("label", "label", null, "");
    }

    public void testMMenuItem_Text_StringEmpty() {
        this.testMMenuItem_Text("label", "label", "", "");
    }

    public void testMMenuItem_Text_StringStringUnchanged() {
        this.testMMenuItem_Text("label", "label", "label", "label");
    }

    public void testMMenuItem_Text_StringStringChanged() {
        this.testMMenuItem_Text("label", "label", "label2", "label2");
    }

    public void testMMenuItem_RadioItems() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MDirectMenuItem menuItem1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        MDirectMenuItem menuItem2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem1.setType(ItemType.RADIO);
        menuItem2.setType(ItemType.RADIO);
        menu.getChildren().add(menuItem1);
        menu.getChildren().add(menuItem2);
        window.setMainMenu(menu);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        ((MenuManager)((Widget)menu.getWidget()).getData()).updateAll(true);
        Object widget1 = menuItem1.getWidget();
        MMenuItemTest.assertNotNull((Object)widget1);
        MMenuItemTest.assertTrue((boolean)(widget1 instanceof MenuItem));
        Object widget2 = menuItem2.getWidget();
        MMenuItemTest.assertNotNull((Object)widget2);
        MMenuItemTest.assertTrue((boolean)(widget2 instanceof MenuItem));
        MenuItem menuItemWidget1 = (MenuItem)widget1;
        MenuItem menuItemWidget2 = (MenuItem)widget2;
        menuItemWidget1.setSelection(false);
        menuItemWidget2.setSelection(true);
        menuItemWidget1.notifyListeners(13, new Event());
        menuItemWidget2.notifyListeners(13, new Event());
        MMenuItemTest.assertFalse((boolean)menuItem1.isSelected());
        MMenuItemTest.assertTrue((boolean)menuItem2.isSelected());
        menuItemWidget2.setSelection(false);
        menuItemWidget1.setSelection(true);
        menuItemWidget2.notifyListeners(13, new Event());
        menuItemWidget1.notifyListeners(13, new Event());
        MMenuItemTest.assertTrue((boolean)menuItem1.isSelected());
        MMenuItemTest.assertFalse((boolean)menuItem2.isSelected());
        menuItem1.setSelected(false);
        MMenuItemTest.assertFalse((boolean)menuItemWidget1.getSelection());
        menuItem2.setSelected(true);
        MMenuItemTest.assertTrue((boolean)menuItemWidget2.getSelection());
    }

    public void testMDirectMenuItem_Check_Bug316752() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem.setType(ItemType.CHECK);
        menuItem.setSelected(true);
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        ((MenuManager)((Widget)menu.getWidget()).getData()).updateAll(true);
        Object widget1 = menuItem.getWidget();
        MMenuItemTest.assertNotNull((Object)widget1);
        MMenuItemTest.assertTrue((boolean)(widget1 instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget1;
        MMenuItemTest.assertTrue((boolean)menuItemWidget.getSelection());
    }

    public void testMHandledMenuItem_Check_Bug316752() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MHandledMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        command.setElementId("commandId");
        menuItem.setCommand(command);
        menuItem.setType(ItemType.CHECK);
        menuItem.setSelected(true);
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManager barManager = (MenuManager)((Menu)menu.getWidget()).getData();
        barManager.updateAll(true);
        Object widget1 = menuItem.getWidget();
        MMenuItemTest.assertNotNull((Object)widget1);
        MMenuItemTest.assertTrue((boolean)(widget1 instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget1;
        MMenuItemTest.assertTrue((boolean)menuItemWidget.getSelection());
    }

    public void testSubMenuCreation() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((String)"failed to create menu bar manager", (Object)manager);
        MMenuItemTest.assertEquals((int)1, (int)manager.getSize());
        MenuManager fileManager = (MenuManager)manager.getItems()[0];
        MenuManager fileR = renderer.getManager(fileMenu);
        MMenuItemTest.assertEquals((Object)fileManager, (Object)fileR);
        MMenuItemTest.assertEquals((int)3, (int)fileManager.getSize());
    }

    public void testTbrItem() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        item2.setToBeRendered(false);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((String)"failed to create menu bar manager", (Object)manager);
        MMenuItemTest.assertEquals((int)1, (int)manager.getSize());
        MenuManager fileManager = (MenuManager)manager.getItems()[0];
        MenuManager fileR = renderer.getManager(fileMenu);
        MMenuItemTest.assertEquals((Object)fileManager, (Object)fileR);
        MMenuItemTest.assertEquals((int)2, (int)fileManager.getSize());
    }

    public void testInvisibleItem() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        item2.setVisible(false);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((String)"failed to create menu bar manager", (Object)manager);
        MMenuItemTest.assertEquals((int)1, (int)manager.getSize());
        MenuManager fileManager = (MenuManager)manager.getItems()[0];
        MenuManager fileR = renderer.getManager(fileMenu);
        MMenuItemTest.assertEquals((Object)fileManager, (Object)fileR);
        MMenuItemTest.assertEquals((int)3, (int)fileManager.getSize());
        MMenuItemTest.assertEquals((boolean)false, (boolean)fileManager.getItems()[2].isVisible());
    }

    public void testMenuContribution() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        application.getMenuContributions().add(this.createContribution(false));
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager fileManager = renderer.getManager(fileMenu);
        MMenuItemTest.assertNotNull((String)"No file menu?", (Object)fileManager);
        MMenuItemTest.assertEquals((int)4, (int)fileManager.getSize());
        MMenuItemTest.assertEquals((String)"mmc.item1", (String)fileManager.getItems()[3].getId());
    }

    public void testWithVisible() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        application.getMenuContributions().add(this.createContribution(true));
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager fileManager = renderer.getManager(fileMenu);
        MMenuItemTest.assertNotNull((String)"No file menu?", (Object)fileManager);
        MMenuItemTest.assertEquals((int)4, (int)fileManager.getSize());
        IContributionItem mmcItem = fileManager.getItems()[3];
        MMenuItemTest.assertEquals((String)"mmc.item1", (String)mmcItem.getId());
        MMenuItemTest.assertEquals((String)"before the first show, we have no context to evaluate", (boolean)true, (boolean)mmcItem.isVisible());
        MenuManager manager = renderer.getManager(menuBar);
        manager.updateAll(true);
        Menu fileWidget = fileManager.getMenu();
        MMenuItemTest.assertNotNull((Object)fileWidget);
        Event show = new Event();
        show.widget = fileWidget;
        show.type = 22;
        Event hide = new Event();
        hide.widget = fileWidget;
        hide.type = 23;
        fileWidget.notifyListeners(22, show);
        MMenuItemTest.assertEquals((String)"after the first show, it should not be visible", (boolean)false, (boolean)mmcItem.isVisible());
        fileWidget.notifyListeners(23, hide);
        this.appContext.set("mmc1", (Object)Boolean.TRUE);
        MMenuItemTest.assertEquals((String)"Change should not show up until next show", (boolean)false, (boolean)mmcItem.isVisible());
        fileWidget.notifyListeners(22, show);
        MMenuItemTest.assertEquals((boolean)true, (boolean)mmcItem.isVisible());
        fileWidget.notifyListeners(23, hide);
        this.appContext.remove("mmc1");
        fileWidget.notifyListeners(22, show);
        MMenuItemTest.assertEquals((boolean)false, (boolean)mmcItem.isVisible());
        fileWidget.notifyListeners(23, hide);
    }

    public void testMenuBarVisibility() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.createMenuContribution(application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager manager = renderer.getManager(menuBar);
        manager.updateAll(true);
        MMenuItemTest.assertEquals((int)2, (int)manager.getSize());
        MenuManager vanishManager = (MenuManager)manager.getItems()[1];
        MMenuItemTest.assertEquals((String)"vanish", (String)vanishManager.getId());
        MMenuItemTest.assertFalse((boolean)vanishManager.isVisible());
        MMenuItemTest.assertNull((Object)vanishManager.getMenu());
        this.appContext.set("mmc1", (Object)Boolean.TRUE);
        MMenuItemTest.assertTrue((boolean)vanishManager.isVisible());
        MMenuItemTest.assertNotNull((Object)vanishManager.getMenu());
        this.appContext.remove("mmc1");
        MMenuItemTest.assertFalse((boolean)vanishManager.isVisible());
        Menu vanishMenu = vanishManager.getMenu();
        if (vanishMenu != null) {
            MMenuItemTest.assertTrue((boolean)vanishMenu.isDisposed());
        }
        this.appContext.set("mmc1", (Object)Boolean.TRUE);
        MMenuItemTest.assertTrue((boolean)vanishManager.isVisible());
        MMenuItemTest.assertNotNull((Object)vanishManager.getMenu());
        MMenuItemTest.assertFalse((boolean)vanishManager.getMenu().isDisposed());
    }

    private MMenuContribution createContribution(boolean withVisibleWhen) {
        MMenuContribution mmc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mmc.setElementId("test.contrib1");
        mmc.setParentId("file");
        mmc.setPositionInParent("after=additions");
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("mmc.item1");
        item1.setLabel("mmc.item1");
        mmc.getChildren().add(item1);
        if (withVisibleWhen) {
            MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
            exp.setCoreExpressionId("org.eclipse.e4.ui.tests.withMmc1");
            mmc.setVisibleWhen((MExpression)exp);
        }
        return mmc;
    }

    private void createMenuContribution(MApplication application) {
        MMenuContribution mmc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mmc.setElementId("test.contrib2");
        mmc.setParentId("org.eclipse.ui.main.menu");
        mmc.setPositionInParent("after=additions");
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        menu.setElementId("vanish");
        menu.setLabel("Vanish");
        mmc.getChildren().add(menu);
        MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
        exp.setCoreExpressionId("org.eclipse.e4.ui.tests.withMmc1");
        mmc.setVisibleWhen((MExpression)exp);
        application.getMenuContributions().add(mmc);
        mmc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mmc.setElementId("test.contrib3");
        mmc.setParentId("vanish");
        mmc.setPositionInParent("after=additions");
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("mmc.item2");
        item1.setLabel("mmc.item2");
        mmc.getChildren().add(item1);
        application.getMenuContributions().add(mmc);
    }

    private MenuManagerRenderer getRenderer(IEclipseContext context, MUIElement element) {
        IRendererFactory rendererFactory = (IRendererFactory)context.get(IRendererFactory.class);
        AbstractPartRenderer renderer = rendererFactory.getRenderer(element, null);
        MMenuItemTest.assertEquals(MenuManagerRenderer.class, renderer.getClass());
        return (MenuManagerRenderer)renderer;
    }
}

