/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerToolBarTest
extends ModelReconcilerTest {
    private void testToolBar_Children_Add(MToolBarElement toolItem) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        toolBar.getChildren().add(toolItem);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerToolBarTest.assertEquals((int)0, (int)toolBar.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerToolBarTest.assertEquals((int)1, (int)toolBar.getChildren().size());
        ModelReconcilerToolBarTest.assertEquals(toolItem.getClass(), ((MToolBarElement)toolBar.getChildren().get(0)).getClass());
    }

    public void testToolBar_Children_Add_ToolBarSeparator() {
        this.testToolBar_Children_Add((MToolBarElement)MenuFactoryImpl.eINSTANCE.createToolBarSeparator());
    }

    public void testToolBar_Children_Add_DirectToolItem() {
        this.testToolBar_Children_Add((MToolBarElement)MenuFactoryImpl.eINSTANCE.createDirectToolItem());
    }

    public void testToolBar_Children_Add_HandledToolItem() {
        this.testToolBar_Children_Add((MToolBarElement)MenuFactoryImpl.eINSTANCE.createHandledToolItem());
    }

    public void testToolBar_Children_Remove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MDirectToolItem toolItem = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        toolBar.getChildren().add(toolItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        toolBar.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        toolItem = (MToolItem)toolBar.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerToolBarTest.assertEquals((int)1, (int)toolBar.getChildren().size());
        ModelReconcilerToolBarTest.assertEquals((Object)toolItem, toolBar.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerToolBarTest.assertEquals((int)0, (int)toolBar.getChildren().size());
    }
}

