/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.tm.builder.IBuilderListener;
import org.eclipse.e4.tm.ui.AbstractModelContext;
import org.eclipse.e4.tm.ui.ModelPartContent;
import org.eclipse.e4.tm.ui.TmPartStyle;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class EditingDomainModelContext
implements IEditingDomainProvider,
IBuilderListener {
    private AdapterFactoryEditingDomain editingDomain;
    private TmPartStyle partStyle;
    private Adapter resourcesChangedHandler = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            Resource resource;
            if (notification.getNotifier() instanceof ResourceSet && notification.getFeatureID(ResourceSet.class) == 0) {
                if (notification.getEventType() == 3 || notification.getEventType() == 5) {
                    for (Resource resource2 : EditingDomainModelContext.this.getResourceSet().getResources()) {
                        if (EditingDomainModelContext.this.resourceModelContentMap.containsKey(resource2)) continue;
                        EditingDomainModelContext.this.resourceAdded(resource2);
                    }
                } else if (notification.getEventType() == 4 || notification.getEventType() == 6) {
                    for (Resource resource3 : EditingDomainModelContext.this.resourceModelContentMap.keySet()) {
                        if (EditingDomainModelContext.this.getResourceSet().getResources().contains((Object)resource3)) continue;
                        EditingDomainModelContext.this.resourceRemoved(resource3);
                    }
                }
            } else if (notification.getNotifier() instanceof Resource && notification.getFeatureID(Resource.class) == 4 && (resource = (Resource)notification.getNotifier()).isLoaded() && !EditingDomainModelContext.this.resourceModelContentMap.containsKey(resource)) {
                EditingDomainModelContext.this.resourceAdded(resource);
            }
        }
    };
    private Map<Resource, ModelPartContent> resourceModelContentMap = new HashMap<Resource, ModelPartContent>();
    private static final String DEFAULT_RESOURCE_URI = "platform:/plugin/org.eclipse.e4.tm.examples/templates/template.tm";
    public final IAction loadResourceAction = new Action("Load resource..."){

        public void run() {
            new ResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Load resource...", 4098){

                protected Control createDialogArea(Composite parent) {
                    Control result = super.createDialogArea(parent);
                    this.uriField.setText(EditingDomainModelContext.DEFAULT_RESOURCE_URI);
                    return result;
                }

                protected boolean processResources() {
                    boolean result = true;
                    for (URI uri : this.getURIs()) {
                        result &= EditingDomainModelContext.this.addResource(uri);
                    }
                    return result;
                }
            }.open();
        }
    };
    private List<IBuilderListener> builderListeners = new ArrayList<IBuilderListener>();

    private void createEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
    }

    public AdapterFactory getAdapterFactory() {
        if (this.editingDomain == null) {
            this.createEditingDomain();
        }
        return this.editingDomain.getAdapterFactory();
    }

    public EditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.createEditingDomain();
        }
        return this.editingDomain;
    }

    public ResourceSet getResourceSet() {
        return this.getEditingDomain().getResourceSet();
    }

    public EditingDomainModelContext(AdapterFactoryEditingDomain editingDomain, TmPartStyle partStyle) {
        this.editingDomain = editingDomain;
        this.partStyle = partStyle;
    }

    public EditingDomainModelContext(TmPartStyle partStyle) {
        this.partStyle = partStyle;
    }

    public void createControls(Composite parent) {
        this.partStyle.createTreeParent(parent);
        for (Resource resource : this.getEditingDomain().getResourceSet().getResources()) {
            this.resourceAdded(resource);
        }
        this.getResourceSet().eAdapters().add((Object)this.resourcesChangedHandler);
    }

    private void resourceAdded(final Resource resource) {
        URI uri = resource.getURI();
        if (!"tm".equals(uri.fileExtension())) {
            return;
        }
        if (!resource.isLoaded()) {
            resource.eAdapters().add((Object)this.resourcesChangedHandler);
        } else {
            resource.eAdapters().remove((Object)this.resourcesChangedHandler);
            ModelPartContent modelContent = new ModelPartContent(this.partStyle.addTmComposite(uri));
            modelContent.getBuilder().addBuilderListener((IBuilderListener)this);
            this.resourceModelContentMap.put(resource, modelContent);
            modelContent.setModelContext(new AbstractModelContext(){

                public EObject getModel() {
                    return resource.getContents().size() > 0 ? (EObject)resource.getContents().get(0) : null;
                }
            });
        }
    }

    private void resourceRemoved(Resource resource) {
        ModelPartContent modelContent = this.resourceModelContentMap.get(resource);
        this.resourceModelContentMap.remove(resource);
        modelContent.dispose();
        this.partStyle.disposeTmComposite(resource);
    }

    public void dispose() {
        for (Resource resource : this.resourceModelContentMap.keySet()) {
            this.resourceRemoved(resource);
        }
    }

    public boolean addResource(URI uri) {
        try {
            this.getResourceSet().getResource(uri, true);
            return true;
        }
        catch (RuntimeException e) {
            System.err.println("Error when getting " + uri + " resource: " + e);
            return false;
        }
    }

    public void addBuilderListener(IBuilderListener builderListener) {
        this.builderListeners.add(builderListener);
    }

    public void removeBuilderListener(IBuilderListener builderListener) {
        this.builderListeners.remove(builderListener);
    }

    public void objectHandled(int id, EObject eObject, Object object) {
        for (IBuilderListener builderListener : this.builderListeners) {
            builderListener.objectHandled(id, eObject, object);
        }
    }
}

