/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.deeplink.typehandler.perspective;

import java.io.IOException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.e4.core.deeplink.api.AbstractDeepLinkTypeHandler;
import org.eclipse.e4.core.deeplink.api.Activator;
import org.eclipse.e4.core.deeplink.api.ParameterProcessResults;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class DeepLinkPerspectiveTypeHandler
extends AbstractDeepLinkTypeHandler {
    private static final String PERSPECTIVE_ID_ATTRIBUTE = "id";
    private static final long serialVersionUID = 1L;

    public void processDeepLink() throws IOException {
        final ParameterProcessResults[] results = new ParameterProcessResults[]{new ParameterProcessResults()};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DeepLinkPerspectiveTypeHandler.this.processPerspectiveOpen(results);
                IConfigurationElement[] congfigElementsFromRegistry = DeepLinkPerspectiveTypeHandler.this.getCongfigElementsFromRegistry("org.eclipse.ui", "perspectives");
                DeepLinkPerspectiveTypeHandler.this.findInstanceHandlerAndExecuteCallback(results, congfigElementsFromRegistry, DeepLinkPerspectiveTypeHandler.this.getParameterMap(), DeepLinkPerspectiveTypeHandler.PERSPECTIVE_ID_ATTRIBUTE);
            }
        });
        this.outputResponse(results[0]);
    }

    private void processPerspectiveOpen(ParameterProcessResults[] results) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        ILog logger = Activator.getDefault().getLog();
        results[0].loaded = this.openPerspective(this.getHandlerId(), (IAdaptable)ResourcesPlugin.getWorkspace(), workbench, store, logger);
    }

    boolean openPerspective(String perspId, IAdaptable input, IWorkbench workbench, IPreferenceStore store, ILog logger) {
        IPerspectiveDescriptor perspective;
        block8: {
            try {
                IPerspectiveRegistry reg = workbench.getPerspectiveRegistry();
                perspective = reg.findPerspectiveWithId(perspId);
                if (perspective != null) break block8;
                logger.log(this.statusFactory.error("Unable to open perspective: " + perspId));
                return false;
            }
            catch (WorkbenchException e) {
                logger.log(this.statusFactory.error("Error opening perspective: " + e.getMessage(), (Throwable)e));
                return false;
            }
        }
        String pref = store.getString("OPEN_NEW_PERSPECTIVE");
        if (pref.equals("OPEN_PERSPECTIVE_WINDOW")) {
            workbench.openWorkbenchWindow(perspId, input);
        } else if (pref.equals("OPEN_PERSPECTIVE_REPLACE")) {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage activePage = window.getActivePage();
            if (activePage != null) {
                activePage.setPerspective(perspective);
            } else {
                window.openPage(perspId, input);
            }
        }
        Shell shell = workbench.getActiveWorkbenchWindow().getShell();
        shell.setMinimized(false);
        shell.forceActive();
        logger.log(this.statusFactory.info("Opened perspective: " + perspId));
        return true;
    }
}

