/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.tooltip;

import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.platform.discovery.ui.internal.tooltip.FormTextBuilder;
import org.eclipse.platform.discovery.ui.internal.tooltip.IToolTipConfigurator;
import org.eclipse.platform.discovery.ui.internal.tooltip.TooltipManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerTooltipManager
extends TooltipManager<TreeItem> {
    private final CellLabelProvider labelProvider;
    private final TreeViewer treeViewer;

    public TreeViewerTooltipManager(TreeViewer treeViewer, CellLabelProvider labelProvider, IInformationControlCreator controlCreator) {
        super(controlCreator);
        this.labelProvider = labelProvider;
        this.treeViewer = treeViewer;
    }

    @Override
    protected IToolTipConfigurator createInformation(TreeItem control) {
        String tooltipText = this.labelProvider.getToolTipText(control.getData());
        if (this.isTooltipTextEmpty(tooltipText)) {
            return null;
        }
        return this.newTooltipConfigurator(tooltipText, control.getText(), control.getImage());
    }

    @Override
    protected TreeItem hoveredWidget() {
        return this.treeViewer.getTree().getItem(this.getHoverEventLocation());
    }

    private IToolTipConfigurator newTooltipConfigurator(final String tooltipText, final String tooltipCaption, final Image titleImage) {
        return new IToolTipConfigurator(){

            @Override
            public Image getTitleImage() {
                return titleImage;
            }

            @Override
            public String getTitleCaption() {
                return tooltipCaption;
            }

            @Override
            public String getFormText() {
                return tooltipText;
            }
        };
    }

    private boolean isTooltipTextEmpty(String tooltipText) {
        return tooltipText == null || tooltipText.isEmpty() || this.newFormTextBuilder().getText().equals(tooltipText);
    }

    protected FormTextBuilder newFormTextBuilder() {
        return new FormTextBuilder();
    }

    @Override
    protected Rectangle hoveredWidgetBounds(TreeItem hoveredWidget) {
        return this.hoveredWidget().getBounds();
    }
}

