/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.platform.discovery.runtime.api.GroupingHierarchy;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.ui.api.ISearchParametersUI;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIPlugin;
import org.eclipse.platform.discovery.ui.internal.selector.InteractiveComboSelector;
import org.eclipse.platform.discovery.ui.internal.view.SearchConsoleView;
import org.eclipse.platform.discovery.ui.internal.view.impl.SubdestinationsSelectedListener;
import org.eclipse.platform.discovery.ui.internal.view.impl.TextControl;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchParametersUI
implements ISearchParametersUI {
    private static final String DROP_DOWN_ICON_LOCATION = "icon-dropdown-keyword-ALT.gif";
    private static final int UI_IN_CONTROL_SPACING = 5;
    private Label openSubdestinationsButton;
    private TextControl keywordTextControl;
    private final Property<Set<ISearchDestination>> destinations = new Property();
    private ISearchParametersUI.IConsoleContext consoleContext;
    private InteractiveComboSelector<GroupingHierarchy> groupingHierarchySelector;

    public SearchParametersUI() {
        this.destinations.registerValueListener((IPropertyAttributeListener)new IPropertyAttributeListener<Set<ISearchDestination>>(){

            public void attributeChanged(PropertyAttributeChangedEvent<Set<ISearchDestination>> event) {
                ISearchProviderDescription currentSearchProvider = SearchParametersUI.this.consoleContext.searchProvider();
                Set newSelection = (Set)event.getNewAttribute();
                SearchParametersUI.this.keywordTextControl.setEnabled(!newSelection.isEmpty() && currentSearchProvider != null && currentSearchProvider.supportsTextSearch());
                this.updateKeywordTextMessage(newSelection);
                if (newSelection.isEmpty() || currentSearchProvider == null) {
                    SearchParametersUI.this.openSubdestinationsButton.setEnabled(false);
                } else {
                    Set allSubdestintations = SearchParametersUI.this.consoleContext.searchProviderConfiguration().getAvailableSearchSubdestinations(SearchParametersUI.this.consoleContext.selectedObjectType(), SearchParametersUI.this.consoleContext.destinationCategory(), SearchParametersUI.this.consoleContext.searchProvider());
                    SearchParametersUI.this.openSubdestinationsButton.setEnabled(allSubdestintations.size() > 0);
                }
                SearchParametersUI.this.consoleContext.notifyComplete(SearchParametersUI.this.isComplete());
            }

            private void updateKeywordTextMessage(Set<ISearchDestination> selectedDestinations) {
                if (selectedDestinations.isEmpty()) {
                    SearchParametersUI.this.keywordTextControl.setMessage(DiscoveryUIMessages.SearchConsoleView_NoDestinationSelectedHint);
                    return;
                }
                ISearchProviderDescription currentSearchProvider = SearchParametersUI.this.consoleContext.searchProvider();
                if (currentSearchProvider != null && currentSearchProvider.supportsTextSearch()) {
                    SearchParametersUI.this.keywordTextControl.setMessage(DiscoveryUIMessages.SearchConsoleView_EnterKeywordHint);
                } else {
                    SearchParametersUI.this.keywordTextControl.setMessage(DiscoveryUIMessages.SearchConsoleView_UnsupportedTextSearch);
                }
            }
        }, false);
    }

    @Override
    public void createUI(Composite parent, FormToolkit formToolkit, ISearchParametersUI.IConsoleContext consoleContext) {
        parent.setLayout((Layout)new FormLayout());
        this.consoleContext = consoleContext;
        Label searchLabel = new Label(parent, 0);
        searchLabel.setText(DiscoveryUIMessages.SEARCH_KEYWORD_LABEL);
        FormData labelFormData = new FormData();
        labelFormData.top = new FormAttachment(0, 5);
        labelFormData.left = new FormAttachment(0, 5);
        searchLabel.setLayoutData((Object)labelFormData);
        this.openSubdestinationsButton = this.createSubdestinationsSelector(parent);
        this.keywordTextControl = this.createKeywordTextControl(parent, formToolkit, searchLabel, consoleContext.secondColumnLeftOffset(), (Control)this.openSubdestinationsButton);
        this.createGroupByComposite(parent, formToolkit, consoleContext.secondColumnLeftOffset(), (Control)this.keywordTextControl.getControl());
    }

    private TextControl createKeywordTextControl(Composite parent, FormToolkit formToolkit, Label leftNeighbour, int leftOffset, Control rightNeighbour) {
        Text keywordText = formToolkit.createText(parent, "", 2176);
        FormData keywordTextFormData = new FormData();
        keywordTextFormData.left = new FormAttachment(0, leftOffset + 10);
        keywordTextFormData.right = new FormAttachment(rightNeighbour, -5);
        keywordText.setLayoutData((Object)keywordTextFormData);
        TextControl control = new TextControl(keywordText, leftNeighbour);
        control.setEnabled(false);
        control.setMessage(DiscoveryUIMessages.SearchConsoleView_NoDestinationSelectedHint);
        control.getControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchParametersUI.this.consoleContext.notifyComplete(SearchParametersUI.this.isComplete());
            }
        });
        return control;
    }

    private Image dropDownButtonImage(Display display) {
        Image img = this.imageRegistry().get(DROP_DOWN_ICON_LOCATION);
        if (img == null) {
            img = new Image((Device)display, SearchConsoleView.class.getResourceAsStream(DROP_DOWN_ICON_LOCATION));
            this.imageRegistry().put(DROP_DOWN_ICON_LOCATION, img);
        }
        return img;
    }

    private ImageRegistry imageRegistry() {
        return DiscoveryUIPlugin.getDefault().getImageRegistry();
    }

    private boolean isComplete() {
        return !((Set)this.destinations.get()).isEmpty() && !this.keywordTextControl.get().isEmpty();
    }

    @Override
    public Map<Object, Object> getParameters() {
        return Collections.emptyMap();
    }

    @Override
    public String getKeyword() {
        return this.keywordTextControl.get();
    }

    @Override
    public GroupingHierarchy getGroupingHierarchy() {
        return (GroupingHierarchy)this.groupingHierarchySelector.getSelectedItem();
    }

    private Label createSubdestinationsSelector(Composite parent) {
        Label selector = new Label(parent, 0);
        FormData subDestButtonFormData = new FormData();
        subDestButtonFormData.right = new FormAttachment(100, -5);
        selector.setLayoutData((Object)subDestButtonFormData);
        selector.setImage(this.dropDownButtonImage(parent.getDisplay()));
        selector.setEnabled(false);
        selector.addListener(3, (Listener)new SubdestinationsSelectedListener((Control)selector, this.consoleContext));
        return selector;
    }

    private void createGroupByComposite(Composite parent, FormToolkit formToolkit, int leftLabelsSize, Control upperNeighbour) {
        this.groupingHierarchySelector = new InteractiveComboSelector(parent, formToolkit, new HashSet(), DiscoveryUIMessages.GROUP_BY_LABEL, leftLabelsSize, upperNeighbour);
        this.groupingHierarchySelector.setEnabled(false);
    }

    @Override
    public void showGroupingHierarchies(Set<GroupingHierarchy> groupingHierarchies) {
        this.groupingHierarchySelector.setInput(groupingHierarchies);
    }

    @Override
    public void destinationSelected(Set<ISearchDestination> destinations) {
        HashSet<ISearchDestination> copy = new HashSet<ISearchDestination>(destinations);
        this.destinations.set(copy);
    }
}

