/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.wizard;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.internal.resources.semantic.ui.SemanticResourcesUIPlugin;
import org.eclipse.core.internal.resources.semantic.ui.wizard.AddUrlResourceCheckURLPage;
import org.eclipse.core.internal.resources.semantic.ui.wizard.AddUrlResourceNameAndURLPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddUrlResourceWizard
extends Wizard
implements INewWizard {
    private static final String DEFAULT_CP_ID = "org.eclipse.core.resources.semantic.provider.DefaultContentProvider";
    AddUrlResourceNameAndURLPage nameAndUrlPage = new AddUrlResourceNameAndURLPage();
    AddUrlResourceCheckURLPage checkPage = new AddUrlResourceCheckURLPage();

    public AddUrlResourceWizard() {
        this.setWindowTitle(Messages.AddUrlResourceWizard_PageTitle_XGRP);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object testObject = selection.getFirstElement();
        if (testObject instanceof IContainer) {
            this.nameAndUrlPage.setResourceContainer((IContainer)testObject);
        } else {
            this.nameAndUrlPage.setResourceContainer(null);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.nameAndUrlPage);
        this.addPage((IWizardPage)this.checkPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.nameAndUrlPage) {
            this.checkPage.setUrl(this.nameAndUrlPage.getUrl());
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor outerMonitor) throws InvocationTargetException, InterruptedException {
                    URI uri;
                    final ISemanticFolder parentResource = (ISemanticFolder)AddUrlResourceWizard.this.nameAndUrlPage.getResourceContainer().getAdapter(ISemanticFolder.class);
                    final boolean shouldRetrieveContent = AddUrlResourceWizard.this.checkPage.shouldRetrieveContent();
                    final boolean forceMode = AddUrlResourceWizard.this.nameAndUrlPage.getForceOverwrite();
                    try {
                        if (parentResource != null) {
                            uri = new URI(AddUrlResourceWizard.this.nameAndUrlPage.getUrl());
                        } else {
                            IPath newPath = AddUrlResourceWizard.this.nameAndUrlPage.getResourceContainer().getFullPath().append(AddUrlResourceWizard.this.nameAndUrlPage.getChildName());
                            uri = new URI("semanticfs", null, newPath.toString(), "type=file;create=true;provider=org.eclipse.core.resources.semantic.provider.DefaultContentProvider;uri=" + URLEncoder.encode(AddUrlResourceWizard.this.nameAndUrlPage.getUrl(), "UTF-8"), null);
                        }
                    }
                    catch (URISyntaxException e1) {
                        throw new InvocationTargetException(e1);
                    }
                    catch (UnsupportedEncodingException e1) {
                        throw new InvocationTargetException(e1);
                    }
                    if (outerMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    try {
                        IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                if (parentResource != null) {
                                    ISemanticResource resource;
                                    if (parentResource.hasResource((this).AddUrlResourceWizard.this.nameAndUrlPage.getChildName())) {
                                        if (!forceMode) {
                                            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.resources.semantic", Messages.AddUrlResourceWizard_AlreadyExists_XMSG));
                                        }
                                        parentResource.getResource((this).AddUrlResourceWizard.this.nameAndUrlPage.getChildName()).remove(2, monitor);
                                    }
                                    ISemanticFile sFile = parentResource.addFile((this).AddUrlResourceWizard.this.nameAndUrlPage.getChildName(), AddUrlResourceWizard.DEFAULT_CP_ID, null, 0, monitor);
                                    sFile.setRemoteURI(uri, 0, monitor);
                                    if (shouldRetrieveContent && (resource = parentResource.getResource((this).AddUrlResourceWizard.this.nameAndUrlPage.getChildName())) != null) {
                                        WorkspaceJob job = new WorkspaceJob(Messages.AddUrlResourceWizard_RetrieveContent_XMSG){

                                            public IStatus runInWorkspace(IProgressMonitor monitor1) throws CoreException {
                                                resource.synchronizeContentWithRemote(SyncDirection.INCOMING, 0, monitor1);
                                                return Status.OK_STATUS;
                                            }
                                        };
                                        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule(resource.getAdaptedResource()));
                                        job.schedule();
                                    }
                                } else {
                                    ISemanticResource sResource;
                                    IFile file;
                                    Path childPath;
                                    IContainer container = (this).AddUrlResourceWizard.this.nameAndUrlPage.getResourceContainer();
                                    if (container.exists((IPath)(childPath = new Path((this).AddUrlResourceWizard.this.nameAndUrlPage.getChildName())))) {
                                        if (!forceMode) {
                                            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.resources.semantic", Messages.AddUrlResourceWizard_AlreadyExists_XMSG));
                                        }
                                        IResource child = container.findMember((this).AddUrlResourceWizard.this.nameAndUrlPage.getChildName());
                                        if (child != null && child.isLinked()) {
                                            IFileStore store;
                                            URI oldURI = child.getLocationURI();
                                            child.delete(true, monitor);
                                            if (oldURI != null && oldURI.getScheme().equals("semanticfs") && (store = EFS.getStore((URI)oldURI)) != null && store instanceof ISemanticFileStore) {
                                                store.delete(0, monitor);
                                            }
                                        } else {
                                            IFile childFile;
                                            IFolder childFolder = container.getFolder((IPath)childPath);
                                            if (childFolder.exists()) {
                                                childFolder.delete(false, monitor);
                                            }
                                            if ((childFile = container.getFile((IPath)childPath)).exists()) {
                                                childFile.delete(false, monitor);
                                            }
                                        }
                                    }
                                    IFile resource = file = container.getFile((IPath)childPath);
                                    file.createLink(uri, 16, monitor);
                                    if (shouldRetrieveContent && (sResource = (ISemanticResource)resource.getAdapter(ISemanticResource.class)) != null) {
                                        sResource.synchronizeContentWithRemote(SyncDirection.INCOMING, 0, monitor);
                                    }
                                }
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(wsr, outerMonitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            SemanticResourcesUIPlugin.handleError(Messages.AddUrlResourceWizard_CreationFailed_XMSG, e.getCause(), true);
            return false;
        }
        catch (InterruptedException e) {
            SemanticResourcesUIPlugin.handleError(Messages.AddUrlResourceWizard_Aborted_XMSG, e, true);
            return false;
        }
        return true;
    }
}

