/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.animation;

import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.animation.EasingFunctionBase;

public class ExponentialEase
extends EasingFunctionBase {
    private double exponent = 2.0;

    public double getExponent() {
        return this.exponent;
    }

    public void setExponent(double exponent) {
        this.exponent = exponent;
    }

    public double ease(double normalizedTime) {
        switch (this.getEasingMode()) {
            case EaseIn: {
                return this.easeValue(normalizedTime);
            }
            case EaseOut: {
                return 1.0 - this.easeValue(1.0 - normalizedTime);
            }
            case EaseInOut: {
                normalizedTime /= 0.5;
                if (normalizedTime < 1.0) {
                    return this.easeValue(normalizedTime) / 2.0;
                }
                return (2.0 - this.easeValue(2.0 - normalizedTime)) / 2.0;
            }
        }
        throw new XWTException(String.valueOf(this.getEasingMode().name()) + " is supported.");
    }

    protected double easeValue(double normalizedTime) {
        return (Math.exp(normalizedTime * this.getExponent()) - 1.0) / (Math.exp(this.getExponent()) - 1.0);
    }
}

