/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.policies.layout;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.e4.xwt.tools.ui.designer.commands.NullLayoutCommandsFactory;
import org.eclipse.e4.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.e4.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.policies.NewResizableEditPolicy;
import org.eclipse.e4.xwt.tools.ui.designer.policies.feedback.CrossFeedback;
import org.eclipse.e4.xwt.tools.ui.designer.policies.feedback.FeedbackHelper;
import org.eclipse.e4.xwt.tools.ui.designer.policies.feedback.FeedbackManager;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.ILayoutEditPolicy;
import org.eclipse.e4.xwt.tools.ui.designer.utils.FigureUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class NullLayoutEditPolicy
extends XYLayoutEditPolicy
implements ILayoutEditPolicy {
    private FeedbackManager fbm = new FeedbackManager((GraphicalEditPolicy)this);
    private CrossFeedback crossFeedback;
    private Polygon targetFeedback;

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        NullLayoutCommandsFactory factory = new NullLayoutCommandsFactory(child);
        return factory.getChangeConstraintCommand(constraint);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NewResizableEditPolicy(29, true);
    }

    protected Command getCreateCommand(CreateRequest request) {
        NullLayoutCommandsFactory factory = new NullLayoutCommandsFactory(this.getHost());
        return factory.getCreateCommand(request);
    }

    protected Command getDeleteDependantCommand(Request request) {
        NullLayoutCommandsFactory factory = new NullLayoutCommandsFactory(this.getHost());
        return factory.getDeleteCommand(request);
    }

    protected void showLayoutTargetFeedback(Request request) {
        if ("create child".equals(request.getType())) {
            if (!FeedbackHelper.showCreationFeedback(this.fbm, (CreateRequest)request)) {
                Point location = ((CreateRequest)request).getLocation().getCopy();
                GraphicalEditPart parent = (GraphicalEditPart)this.getHost();
                if (!(parent instanceof CompositeEditPart)) {
                    return;
                }
                if (this.crossFeedback == null) {
                    this.crossFeedback = new CrossFeedback(location);
                }
                if (this.targetFeedback == null) {
                    this.targetFeedback = FeedbackHelper.createTargetFeedback();
                }
                FeedbackHelper.updateTargetFeedback(parent, this.targetFeedback);
                this.addFeedback((IFigure)this.targetFeedback);
                Point center = FigureUtil.translateToRelative((EditPart)parent, location);
                this.crossFeedback.setTooltipText("(" + center.x + "," + center.y + ")");
                this.crossFeedback.setCenter(location);
                this.addFeedback((IFigure)this.crossFeedback);
            }
        } else {
            super.showLayoutTargetFeedback(request);
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.fbm.eraseFeedback(request);
        if (this.crossFeedback != null && this.crossFeedback.getParent() != null) {
            this.removeFeedback((IFigure)this.crossFeedback);
        }
        if (this.targetFeedback != null && this.targetFeedback.getParent() != null) {
            this.removeFeedback((IFigure)this.targetFeedback);
        }
        super.eraseLayoutTargetFeedback(request);
    }

    public void refresh() {
    }

    public LayoutType getType() {
        return LayoutType.NullLayout;
    }
}

