/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.tools.services.IResourceProviderService;
import org.eclipse.e4.tools.services.IResourceService;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceService
implements IResourceService {
    private Map<Display, DisplayPool> displayPool = new HashMap<Display, DisplayPool>();
    private BundleContext context;

    public ResourceService() {
        Bundle b = FrameworkUtil.getBundle(ResourceService.class);
        this.context = b.getBundleContext();
    }

    protected void removePooledResource(PooledResource<?> resource) {
        if (resource.getResource() instanceof Image) {
            this.displayPool.get(((PooledResource)resource).display).getImagePool().remove(resource);
        } else if (resource.getResource() instanceof Color) {
            this.displayPool.get(((PooledResource)resource).display).getColorPool().remove(resource);
        } else if (resource.getResource() instanceof Font) {
            this.displayPool.get(((PooledResource)resource).display).getFontPool().remove(resource);
        }
    }

    private <R extends Resource> PooledResource<R> loadResource(Display display, String key, Type type) {
        DisplayPool p = this.displayPool.get(display);
        PooledResource<Object> resource = null;
        if (p != null) {
            resource = type == Type.IMAGE ? p.getImagePool().get(key) : (type == Type.COLOR ? p.getColorPool().get(key) : p.getFontPool().get(key));
        }
        if (resource != null) {
            PooledResource<Image> pooledResource = resource;
            ((PooledResource)pooledResource).count = ((PooledResource)pooledResource).count + 1;
        } else {
            resource = new PooledResource<Resource>(display, this, key, (Resource)this.lookupResource(display, key, type));
            if (p == null) {
                p = new DisplayPool();
                this.displayPool.put(display, p);
            }
            if (type == Type.IMAGE) {
                p.getImagePool().put(key, resource);
            } else if (type == Type.COLOR) {
                p.getColorPool().put(key, resource);
            } else {
                p.getFontPool().put(key, resource);
            }
        }
        return resource;
    }

    private <R> R lookupResource(Display display, String key, Type type) {
        if (type == Type.IMAGE) {
            IResourceProviderService provider = this.lookupOSGI(key);
            if (provider != null) {
                return (R)provider.getImage(display, key);
            }
        } else if (type == Type.COLOR) {
            IResourceProviderService provider = this.lookupOSGI(key);
            if (provider != null) {
                return (R)provider.getColor(display, key);
            }
        } else {
            IResourceProviderService provider = this.lookupOSGI(key);
            if (provider != null) {
                return (R)provider.getFont(display, key);
            }
        }
        throw new IllegalArgumentException("No provider known for '" + key + "'.");
    }

    private IResourceProviderService lookupOSGI(String key) {
        try {
            Collection refs = this.context.getServiceReferences(IResourceProviderService.class, "(" + key + "=*)");
            if (!refs.isEmpty()) {
                ServiceReference ref = (ServiceReference)refs.iterator().next();
                return (IResourceProviderService)this.context.getService(ref);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public PooledResource<Image> getImage(Display display, String key) {
        return this.loadResource(display, key, Type.IMAGE);
    }

    public PooledResource<Color> getColor(Display display, String key) {
        return this.loadResource(display, key, Type.COLOR);
    }

    public PooledResource<Font> getFont(Display display, String key) {
        return this.loadResource(display, key, Type.FONT);
    }

    @Override
    public IResourceService.IDiposeableResourcePool getResourcePool(Display display) {
        return new ResourcePool(this, display);
    }

    @Override
    public IResourcePool getControlPool(Control control) {
        final ResourcePool pool = new ResourcePool(this, control.getDisplay());
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                pool.dispose();
            }
        });
        return pool;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DisplayPool {
        private Map<String, PooledResource<Image>> imagePool;
        private Map<String, PooledResource<Color>> colorPool;
        private Map<String, PooledResource<Font>> fontPool;

        DisplayPool() {
        }

        public Map<String, PooledResource<Color>> getColorPool() {
            if (this.colorPool == null) {
                this.colorPool = new HashMap<String, PooledResource<Color>>();
            }
            return this.colorPool;
        }

        public Map<String, PooledResource<Image>> getImagePool() {
            if (this.imagePool == null) {
                this.imagePool = new HashMap<String, PooledResource<Image>>();
            }
            return this.imagePool;
        }

        public Map<String, PooledResource<Font>> getFontPool() {
            if (this.fontPool == null) {
                this.fontPool = new HashMap<String, PooledResource<Font>>();
            }
            return this.fontPool;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PooledResource<T extends Resource>
    implements IResourceService.IPooledResource<T> {
        private Display display;
        private int count;
        private T resource;
        private String imageKey;
        private ResourceService resourceService;

        PooledResource(Display display, ResourceService resourceService, String imageKey, T resource) {
            this.display = display;
            this.imageKey = imageKey;
            this.count = 1;
            this.resourceService = resourceService;
            this.resource = resource;
        }

        @Override
        public T getResource() {
            return this.resource;
        }

        @Override
        public void dispose() {
            --this.count;
            if (this.count == 0) {
                this.resourceService.removePooledResource(this);
                if (this.resource != null) {
                    this.resource.dispose();
                }
                this.resource = null;
                this.imageKey = null;
                this.resourceService = null;
            }
        }
    }

    static class ResourcePool
    implements IResourceService.IDiposeableResourcePool {
        private ResourceService resourceService;
        private List<PooledResource<Image>> pooledImages = new ArrayList<PooledResource<Image>>();
        private List<PooledResource<Font>> pooledFonts = new ArrayList<PooledResource<Font>>();
        private List<PooledResource<Color>> pooledColors = new ArrayList<PooledResource<Color>>();
        private Display display;

        @Inject
        public ResourcePool(ResourceService resourceService, Display display) {
            this.display = display;
            this.resourceService = resourceService;
        }

        public Image getImage(String key) throws CoreException {
            if (this.resourceService == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.e4.tools.services", "The pool is disposed"));
            }
            PooledResource<Image> image = null;
            for (PooledResource<Image> img : this.pooledImages) {
                if (!((PooledResource)img).imageKey.equals(key)) continue;
                image = img;
            }
            if (image == null) {
                image = this.resourceService.getImage(this.display, key);
                this.pooledImages.add(image);
            }
            return (Image)image.getResource();
        }

        public Font getFont(String key) throws CoreException {
            if (this.resourceService == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.e4.tools.services", "The pool is disposed"));
            }
            PooledResource<Font> font = null;
            for (PooledResource<Font> fon : this.pooledFonts) {
                if (!((PooledResource)fon).imageKey.equals(key)) continue;
                font = fon;
            }
            if (font == null) {
                font = this.resourceService.getFont(this.display, key);
                this.pooledFonts.add(font);
            }
            return (Font)font.getResource();
        }

        public Color getColor(String key) throws CoreException {
            if (this.resourceService == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.e4.tools.services", "The pool is disposed"));
            }
            PooledResource<Color> color = null;
            for (PooledResource<Color> col : this.pooledColors) {
                if (!((PooledResource)col).imageKey.equals(key)) continue;
                color = col;
            }
            if (color == null) {
                color = this.resourceService.getColor(this.display, key);
                this.pooledColors.add(color);
            }
            return (Color)color.getResource();
        }

        public Image getImageUnchecked(String key) {
            try {
                return this.getImage(key);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        public Font getFontUnchecked(String key) {
            try {
                return this.getFont(key);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        public Color getColorUnchecked(String key) {
            try {
                return this.getColor(key);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        @PreDestroy
        public void dispose() {
            for (IResourceService.IPooledResource iPooledResource : this.pooledImages) {
                iPooledResource.dispose();
            }
            for (IResourceService.IPooledResource iPooledResource : this.pooledFonts) {
                iPooledResource.dispose();
            }
            for (IResourceService.IPooledResource iPooledResource : this.pooledColors) {
                iPooledResource.dispose();
            }
            this.resourceService = null;
            this.pooledImages = null;
            this.pooledFonts = null;
            this.pooledColors = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        IMAGE,
        FONT,
        COLOR;

    }
}

