/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.webdav;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.semantic.examples.webdav.MultistatusType;
import org.eclipse.core.resources.semantic.examples.webdav.ObjectFactory;
import org.eclipse.core.resources.semantic.examples.webdav.PropType;
import org.eclipse.core.resources.semantic.examples.webdav.PropstatType;
import org.eclipse.core.resources.semantic.examples.webdav.ResponseType;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PropfindResponseReader {
    ObjectFactory factory = new ObjectFactory();

    public MultistatusType loadMultitatusTypeFromResponse(InputStream content, IProgressMonitor monitor) throws IOException {
        MultistatusType ms;
        block7: {
            ms = null;
            try {
                if (content == null) break block7;
                try {
                    String name;
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = builder.parse(content);
                    Element node = doc.getDocumentElement();
                    if (node != null && ((name = node.getNodeName()).endsWith(":multistatus") || name.equals("multistatus"))) {
                        ms = this.factory.createMultistatusType();
                        this.loadMultitatus(node, ms);
                    }
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
            }
            finally {
                Util.safeClose((InputStream)content);
            }
        }
        return ms;
    }

    private void loadMultitatus(Node root, MultistatusType ms) {
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.endsWith(":response") || name.equals("response")) {
                ResponseType response = this.factory.createResponseType();
                ms.getResponse().add(response);
                this.loadResponse(node, response);
            }
            ++i;
        }
    }

    private void loadResponse(Node root, ResponseType response) {
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.endsWith(":href") || name.equals("href")) {
                response.setHref(this.getTextFromNode(node));
            }
            if (name.endsWith(":propstat") || name.equals("propstat")) {
                PropstatType propstat = this.factory.createPropstatType();
                response.getPropstat().add(propstat);
                this.loadPropstat(node, propstat);
            }
            ++i;
        }
    }

    private void loadPropstat(Node root, PropstatType propstat) {
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.endsWith(":status") || name.equals("status")) {
                propstat.setStatus(this.getTextFromNode(node));
            }
            if (name.endsWith(":prop") || name.equals("prop")) {
                PropType prop = this.factory.createPropType();
                propstat.setProp(prop);
                this.loadProp(node, prop);
            }
            ++i;
        }
    }

    private void loadProp(Node root, PropType prop) {
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node child;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.endsWith(":getlastmodified") || name.equals("getlastmodified")) {
                prop.setLastmodified(this.getTextFromNode(node));
            }
            if (name.endsWith(":getcontenttype") || name.equals("getcontenttype")) {
                prop.setContentType(this.getTextFromNode(node));
            }
            if (name.endsWith(":getetag") || name.equals("getetag")) {
                prop.setETag(this.getTextFromNode(node));
            }
            if (name.endsWith(":displayname") || name.equals("displayname")) {
                prop.setDisplayname(this.getTextFromNode(node));
            }
            if ((name.endsWith(":resourcetype") || name.equals("resourcetype")) && (child = node.getFirstChild()) != null) {
                String childName = child.getNodeName();
                if (childName.endsWith(":collection") || childName.equals("collection")) {
                    prop.setIsFolder(true);
                } else {
                    prop.setIsFolder(false);
                }
            }
            if (name.endsWith(":supportedlock") || name.equals("supportedlock")) {
                NodeList lockEntryNodes = node.getChildNodes();
                int j = 0;
                while (j < lockEntryNodes.getLength()) {
                    Node lockEntryNode = lockEntryNodes.item(j);
                    NodeList lockNodes = lockEntryNode.getChildNodes();
                    int k = 0;
                    while (k < lockNodes.getLength()) {
                        Node lockScopeNode;
                        String lockScopeNodeName;
                        Node lockNode = lockNodes.item(k);
                        String lockNodeName = lockNode.getNodeName();
                        if ((lockNodeName.endsWith(":lockscope") || lockNodeName.equals("lockscope")) && ((lockScopeNodeName = (lockScopeNode = lockNode.getFirstChild()).getNodeName()).endsWith(":exclusive") || lockScopeNodeName.equals("exclusive"))) {
                            prop.setSupportsLocking(true);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private String getTextFromNode(Node node) {
        Node text = node.getFirstChild();
        if (text != null) {
            return text.getNodeValue();
        }
        String value = node.getNodeValue();
        if (value != null) {
            return value;
        }
        return null;
    }
}

