/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.examples.HandlerUtilities;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItemSelectionDialog;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class HandleAddFromRemote
extends HandlerUtilities {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block19: {
            RemoteItemSelectionDialog dialog;
            IContainer folder;
            block18: {
                ArrayList<RemoteItem> addable;
                block17: {
                    ISemanticFolder sFolder = (ISemanticFolder)this.getSelectedObject(event, ISemanticFolder.class, true);
                    if (sFolder == null) {
                        this.showPopup(Messages.HandleAddFromRemote_Error_XGRP, Messages.HandleAddFromRemote_NotSemantic_XMSG);
                        return null;
                    }
                    folder = sFolder.getAdaptedContainer();
                    try {
                        while (sFolder != null && sFolder.getContentProviderID() == null) {
                            IContainer parent = sFolder.getAdaptedContainer().getParent();
                            if (parent != null) {
                                sFolder = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (CoreException e) {
                        throw new ExecutionException(e.getMessage(), (Throwable)e);
                    }
                    if (sFolder == null) {
                        this.showPopup(Messages.HandleAddFromRemote_Info_XGRP, Messages.HandleAddFromRemote_NoRemote_XMSG);
                        return null;
                    }
                    int templateFolderSegments = sFolder.getAdaptedContainer().getFullPath().segmentCount();
                    RemoteStore store = (RemoteStore)folder.getProject().getAdapter(RemoteStore.class);
                    if (store == null) {
                        this.showPopup(Messages.HandleAddFromRemote_Info_XGRP, Messages.HandleAddFromRemote_NoRemote_XMSG);
                        return null;
                    }
                    RemoteItem item = store.getItemByPath(folder.getFullPath().removeFirstSegments(templateFolderSegments));
                    try {
                        IResource[] members = folder.members();
                        ArrayList<String> memberNames = new ArrayList<String>();
                        IResource[] iResourceArray = members;
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            memberNames.add(member.getName());
                            ++n2;
                        }
                        List children = ((RemoteFolder)item).getChildren();
                        addable = new ArrayList<RemoteItem>();
                        for (RemoteItem childItem : children) {
                            if (memberNames.contains(childItem.getName())) continue;
                            addable.add(childItem);
                        }
                        if (!addable.isEmpty()) break block17;
                        this.showPopup(Messages.HandleAddFromRemote_Info_XGRP, Messages.HandleAddFromRemote_NoRemote_XMSG);
                        return null;
                    }
                    catch (CoreException e) {
                        throw new ExecutionException(e.getMessage(), (Throwable)e);
                    }
                }
                dialog = new RemoteItemSelectionDialog(Display.getCurrent().getActiveShell(), addable.toArray(new RemoteItem[0]), true);
                int result = dialog.open();
                if (result == 0) break block18;
                return null;
            }
            try {
                this.submit(Display.getCurrent().getActiveShell(), new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor actMonitor) throws CoreException {
                                ISemanticFolder sfolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                                for (RemoteItem addItem : dialog.getSelectedItems()) {
                                    sfolder.addResource(addItem.getName(), 0, actMonitor);
                                }
                            }
                        };
                        try {
                            ResourcesPlugin.getWorkspace().run(runnable, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                break block19;
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
            {
            }
        }
        return null;
    }
}

