/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.launchproxy;

import java.util.Date;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.deeplink.DeepLinkManager;
import org.eclipse.e4.core.deeplink.DeepLinkResult;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;

public class Application
implements IApplication {
    private final String COMMANDLINE_KEY = "application.args";
    static ILog stubLogger = new ILog(){

        public void addLogListener(ILogListener listener) {
        }

        public Bundle getBundle() {
            return null;
        }

        public void log(IStatus status) {
            if (4 == status.getSeverity()) {
                System.err.println(new Date() + ": " + status.toString());
                Throwable e = status.getException();
                if (e != null) {
                    e.printStackTrace(System.err);
                }
            } else {
                System.out.println(new Date() + ": " + status.toString());
            }
            System.err.flush();
            System.out.flush();
        }

        public void removeLogListener(ILogListener listener) {
        }
    };

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        ILog systemLog = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.e4.core.deeplink.launchproxy"));
        TeeLogger logger = new TeeLogger(systemLog);
        DeepLinkManager installationManager = new DeepLinkManager(false, (ILog)logger);
        try {
            DeepLinkResult result = installationManager.processDeepLink(Application.getDeepLinkURL(args, logger));
            for (Object key : result.outputData.keySet()) {
                Object value = result.outputData.get(key);
                System.out.println(key + " ==> " + value);
            }
        }
        catch (Exception e) {
            logger.log((IStatus)new Status(4, "org.eclipse.e4.core.deeplink.launchproxy", "Unhandled exception: " + e.getMessage(), (Throwable)e));
        }
        return IApplication.EXIT_OK;
    }

    private static String getDeepLinkURL(String[] args, ILog logger) {
        if (args.length != 1) {
            logger.log((IStatus)new Status(4, "org.eclipse.e4.core.deeplink.launchproxy", "Wrong number of arguments: " + args.length));
            throw new IllegalArgumentException("Wrong number of arguments: " + args.length);
        }
        return args[0];
    }

    public void stop() {
    }

    public static void main(String[] args) {
        DeepLinkManager installationManager = new DeepLinkManager(false, stubLogger);
        installationManager.processDeepLink(Application.getDeepLinkURL(args, stubLogger));
    }

    private class TeeLogger
    implements ILog {
        private ILog delegate;

        public TeeLogger(ILog delegate) {
            this.delegate = delegate;
        }

        public void addLogListener(ILogListener listener) {
            this.delegate.addLogListener(listener);
        }

        public Bundle getBundle() {
            return this.delegate.getBundle();
        }

        public void log(IStatus status) {
            if (4 == status.getSeverity()) {
                this.delegate.log(status);
                System.err.println(new Date() + ": " + status.toString());
                Throwable e = status.getException();
                if (e != null) {
                    e.printStackTrace(System.err);
                }
            } else {
                System.out.println(new Date() + ": " + status.toString());
            }
            System.err.flush();
            System.out.flush();
        }

        public void removeLogListener(ILogListener listener) {
            this.delegate.removeLogListener(listener);
        }
    }
}

